/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.timemachine;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.Scopes;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.batch.components.PastSnapshot;
import org.sonar.batch.components.TimeMachineConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DependedUpon(value={"END_OF_TIME_MACHINE"})
public final class NewCoverageFileAnalyzer
implements Decorator {
    private List<PeriodStruct> structs;

    public NewCoverageFileAnalyzer(TimeMachineConfiguration timeMachineConfiguration) {
        this.structs = Lists.newArrayList();
        for (PastSnapshot pastSnapshot : timeMachineConfiguration.getProjectPastSnapshots()) {
            this.structs.add(new PeriodStruct(pastSnapshot));
        }
    }

    NewCoverageFileAnalyzer(List<PeriodStruct> structs) {
        this.structs = structs;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return project.isLatestAnalysis() && !this.structs.isEmpty();
    }

    private boolean shouldDecorate(Resource resource) {
        return Scopes.isFile((Resource)resource) && !"UTS".equals(resource.getQualifier());
    }

    @DependsUpon
    public List<Metric> dependsOnMetrics() {
        return Arrays.asList(CoreMetrics.SCM_LAST_COMMIT_DATETIMES_BY_LINE, CoreMetrics.COVERAGE_LINE_HITS_DATA, CoreMetrics.CONDITIONS_BY_LINE, CoreMetrics.COVERED_CONDITIONS_BY_LINE);
    }

    @DependedUpon
    public List<Metric> generatesNewCoverageMetrics() {
        return Arrays.asList(CoreMetrics.NEW_LINES_TO_COVER, CoreMetrics.NEW_UNCOVERED_LINES, CoreMetrics.NEW_CONDITIONS_TO_COVER, CoreMetrics.NEW_UNCOVERED_CONDITIONS);
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (this.shouldDecorate(resource)) {
            this.doDecorate(context);
        }
    }

    void doDecorate(DecoratorContext context) {
        if (this.parse(context)) {
            this.compute(context);
        }
    }

    private boolean parse(DecoratorContext context) {
        Measure lastCommits = context.getMeasure(CoreMetrics.SCM_LAST_COMMIT_DATETIMES_BY_LINE);
        Measure hitsByLineMeasure = context.getMeasure(CoreMetrics.COVERAGE_LINE_HITS_DATA);
        if (lastCommits != null && lastCommits.hasData() && hitsByLineMeasure != null && hitsByLineMeasure.hasData()) {
            Map datesByLine = KeyValueFormat.parseIntDateTime((String)lastCommits.getData());
            Map<Integer, Integer> hitsByLine = this.parseCountByLine(hitsByLineMeasure);
            Map<Integer, Integer> conditionsByLine = this.parseCountByLine(context.getMeasure(CoreMetrics.CONDITIONS_BY_LINE));
            Map<Integer, Integer> coveredConditionsByLine = this.parseCountByLine(context.getMeasure(CoreMetrics.COVERED_CONDITIONS_BY_LINE));
            this.reset();
            for (Map.Entry<Integer, Integer> entry : hitsByLine.entrySet()) {
                int lineId = entry.getKey();
                int hits = entry.getValue();
                int conditions = (Integer)ObjectUtils.defaultIfNull((Object)conditionsByLine.get(lineId), (Object)0);
                int coveredConditions = (Integer)ObjectUtils.defaultIfNull((Object)coveredConditionsByLine.get(lineId), (Object)0);
                Date date = (Date)datesByLine.get(lineId);
                for (PeriodStruct struct : this.structs) {
                    struct.analyze(date, hits, conditions, coveredConditions);
                }
            }
            return true;
        }
        return false;
    }

    private void reset() {
        for (PeriodStruct struct : this.structs) {
            struct.reset();
        }
    }

    private void compute(DecoratorContext context) {
        Measure newLines = new Measure(CoreMetrics.NEW_LINES_TO_COVER);
        Measure newUncoveredLines = new Measure(CoreMetrics.NEW_UNCOVERED_LINES);
        Measure newConditions = new Measure(CoreMetrics.NEW_CONDITIONS_TO_COVER);
        Measure newUncoveredConditions = new Measure(CoreMetrics.NEW_UNCOVERED_CONDITIONS);
        for (PeriodStruct struct : this.structs) {
            newLines.setVariation(struct.index, Double.valueOf(struct.newLines));
            newUncoveredLines.setVariation(struct.index, Double.valueOf(struct.newLines - struct.newCoveredLines));
            newConditions.setVariation(struct.index, Double.valueOf(struct.newConditions));
            newUncoveredConditions.setVariation(struct.index, Double.valueOf((double)struct.newConditions - (double)struct.newCoveredConditions));
        }
        context.saveMeasure(newLines);
        context.saveMeasure(newUncoveredLines);
        context.saveMeasure(newConditions);
        context.saveMeasure(newUncoveredConditions);
    }

    private Map<Integer, Integer> parseCountByLine(Measure measure) {
        if (measure != null && measure.hasData()) {
            return KeyValueFormat.parseIntInt((String)measure.getData());
        }
        return Maps.newHashMap();
    }

    public static final class PeriodStruct {
        int index;
        Date date;
        int newLines = 0;
        int newCoveredLines = 0;
        int newConditions = 0;
        int newCoveredConditions = 0;

        PeriodStruct(PastSnapshot pastSnapshot) {
            this.index = pastSnapshot.getIndex();
            this.date = pastSnapshot.getTargetDate();
        }

        PeriodStruct(int index, Date date) {
            this.index = index;
            this.date = date;
        }

        void reset() {
            this.newLines = 0;
            this.newCoveredLines = 0;
            this.newConditions = 0;
            this.newCoveredConditions = 0;
        }

        void analyze(Date lineDate, int hits, int conditions, int coveredConditions) {
            if (lineDate != null && lineDate.after(this.date)) {
                this.addLine(hits > 0);
                this.addConditions(conditions, coveredConditions);
            }
        }

        void addLine(boolean covered) {
            ++this.newLines;
            if (covered) {
                ++this.newCoveredLines;
            }
        }

        void addConditions(int count, int countCovered) {
            this.newConditions += count;
            if (count > 0) {
                this.newCoveredConditions += countCovered;
            }
        }
    }
}

