/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.timemachine;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Qualifiers;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.Scopes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DependedUpon(value={"END_OF_TIME_MACHINE"})
public final class NewCoverageAggregator
implements Decorator {
    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    @DependedUpon
    public List<Metric> generatesNewCoverageMetrics() {
        return Arrays.asList(CoreMetrics.NEW_LINES_TO_COVER, CoreMetrics.NEW_UNCOVERED_LINES, CoreMetrics.NEW_CONDITIONS_TO_COVER, CoreMetrics.NEW_UNCOVERED_CONDITIONS);
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (this.shouldDecorate(resource)) {
            int maxPeriods = Qualifiers.isView((Resource)resource, (boolean)true) ? 3 : 5;
            this.aggregate(context, CoreMetrics.NEW_LINES_TO_COVER, maxPeriods);
            this.aggregate(context, CoreMetrics.NEW_UNCOVERED_LINES, maxPeriods);
            this.aggregate(context, CoreMetrics.NEW_CONDITIONS_TO_COVER, maxPeriods);
            this.aggregate(context, CoreMetrics.NEW_UNCOVERED_CONDITIONS, maxPeriods);
        }
    }

    void aggregate(DecoratorContext context, Metric metric, int maxPeriods) {
        int[] variations = new int[]{0, 0, 0, 0, 0};
        boolean[] hasValues = new boolean[]{false, false, false, false, false};
        for (Measure child : context.getChildrenMeasures(metric)) {
            for (int indexPeriod = 1; indexPeriod <= maxPeriods; ++indexPeriod) {
                Double variation = child.getVariation(indexPeriod);
                if (variation == null) continue;
                variations[indexPeriod - 1] = variations[indexPeriod - 1] + variation.intValue();
                hasValues[indexPeriod - 1] = true;
            }
        }
        if (ArrayUtils.contains((boolean[])hasValues, (boolean)true)) {
            Measure measure = new Measure(metric);
            for (int index = 0; index < 5; ++index) {
                if (!hasValues[index]) continue;
                measure.setVariation(index + 1, Double.valueOf(variations[index]));
            }
            context.saveMeasure(measure);
        }
    }

    boolean shouldDecorate(Resource resource) {
        return Scopes.isHigherThan((Resource)resource, (String)"FIL");
    }
}

