/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.testdetailsviewer.client;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import org.sonar.gwt.ui.Page;
import org.sonar.gwt.ui.ViewerHeader;
import org.sonar.plugins.core.testdetailsviewer.client.TestsPanel;
import org.sonar.wsclient.services.Measure;
import org.sonar.wsclient.services.Resource;

public class TestsViewer
extends Page {
    public static final String GWT_ID = "org.sonar.plugins.core.testdetailsviewer.TestsViewer";

    protected Widget doOnResourceLoad(Resource resource) {
        FlowPanel flowPanel = new FlowPanel();
        flowPanel.add((Widget)new UnitTestsHeader(resource));
        flowPanel.add((Widget)new TestsPanel(resource));
        return flowPanel;
    }

    private static class UnitTestsHeader
    extends ViewerHeader {
        public UnitTestsHeader(Resource resource) {
            super(resource, new String[]{"test_errors", "test_failures", "test_success_density", "tests", "skipped_tests", "test_execution_time"});
        }

        protected void display(FlowPanel header, Resource resource) {
            HorizontalPanel panel = new HorizontalPanel();
            header.add((Widget)panel);
            Measure measure = resource.getMeasure("test_success_density");
            if (measure == null) {
                this.addBigCell((Panel)panel, "100%");
            } else {
                this.addBigCell((Panel)panel, measure.getFormattedValue());
            }
            String skippedHtml = "";
            Measure skipped = resource.getMeasure("skipped_tests");
            if (skipped != null && skipped.getValue() > 0.0) {
                skippedHtml = skippedHtml + " (+" + skipped.getFormattedValue() + " skipped)";
            }
            this.addCell((Panel)panel, "Tests: ", resource.getMeasureFormattedValue("tests", "-") + skippedHtml);
            this.addCell((Panel)panel, "Failures/Errors: ", resource.getMeasureFormattedValue("test_failures", "0") + "/" + resource.getMeasureFormattedValue("test_errors", "0"));
            this.addCell((Panel)panel, "Duration: ", resource.getMeasureFormattedValue("test_execution_time", "-"));
        }
    }
}

