/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.sensors;

import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.MeasuresFilters;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.RuleMeasure;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.rules.RuleUtils;
import org.sonar.api.utils.KeyValueFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedViolationsDecorator
implements Decorator {
    private Map<RulePriority, Integer> weights;

    @DependsUpon
    public Metric dependsUponViolations() {
        return CoreMetrics.VIOLATIONS;
    }

    @DependedUpon
    public Metric generatesWeightedViolations() {
        return CoreMetrics.WEIGHTED_VIOLATIONS;
    }

    public WeightedViolationsDecorator() {
    }

    protected WeightedViolationsDecorator(Map<RulePriority, Integer> weights) {
        this.weights = weights;
    }

    private void loadWeights(DecoratorContext context) {
        if (this.weights == null && context != null) {
            this.weights = RuleUtils.getPriorityWeights((Configuration)context.getProject().getConfiguration());
        }
    }

    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    public void decorate(Resource resource, DecoratorContext context) {
        this.loadWeights(context);
        double debt = 0.0;
        TreeMultiset violationsByPriority = TreeMultiset.create();
        for (RuleMeasure violations : (Collection)context.getMeasures(MeasuresFilters.rules((Metric)CoreMetrics.VIOLATIONS))) {
            if (!MeasureUtils.hasValue((Measure)violations)) continue;
            violationsByPriority.add((Object)violations.getRulePriority(), violations.getValue().intValue());
            double add = (double)this.weights.get(violations.getRulePriority()).intValue() * violations.getValue();
            debt += add;
        }
        Measure debtMeasure = new Measure(CoreMetrics.WEIGHTED_VIOLATIONS, Double.valueOf(debt), KeyValueFormat.format((Multiset)violationsByPriority));
        this.saveMeasure(context, debtMeasure);
    }

    private void saveMeasure(DecoratorContext context, Measure debtMeasure) {
        if (debtMeasure.getValue() > 0.0) {
            context.saveMeasure(debtMeasure);
        }
    }
}

