/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.sensors;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViolationsDensityDecorator
implements Decorator {
    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    @DependsUpon
    public List<Metric> dependsUponWeightedViolationsAndNcloc() {
        return Arrays.asList(CoreMetrics.WEIGHTED_VIOLATIONS, CoreMetrics.NCLOC);
    }

    @DependedUpon
    public Metric generatesViolationsDensity() {
        return CoreMetrics.VIOLATIONS_DENSITY;
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (this.shouldDecorateResource(context)) {
            this.decorateDensity(context);
        }
    }

    protected boolean shouldDecorateResource(DecoratorContext context) {
        return context.getMeasure(CoreMetrics.VIOLATIONS_DENSITY) == null;
    }

    private void decorateDensity(DecoratorContext context) {
        Measure ncloc = context.getMeasure(CoreMetrics.NCLOC);
        if (MeasureUtils.hasValue((Measure)ncloc) && ncloc.getValue() > 0.0) {
            this.saveDensity(context, ncloc.getValue().intValue());
        }
    }

    private void saveDensity(DecoratorContext context, int ncloc) {
        Measure debt = context.getMeasure(CoreMetrics.WEIGHTED_VIOLATIONS);
        Integer debtValue = 0;
        if (MeasureUtils.hasValue((Measure)debt)) {
            debtValue = debt.getValue().intValue();
        }
        double density = ViolationsDensityDecorator.calculate(debtValue, ncloc);
        context.saveMeasure(CoreMetrics.VIOLATIONS_DENSITY, Double.valueOf(density));
    }

    protected static double calculate(int debt, int ncloc) {
        double rci = (1.0 - (double)debt / (double)ncloc) * 100.0;
        rci = Math.max(rci, 0.0);
        return rci;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

