/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.sensors;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.MeasuresFilters;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.RuleMeasure;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.rules.Violation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DependsUpon(value={"END_OF_VIOLATION_TRACKING"})
public class ViolationsDecorator
implements Decorator {
    private Multiset<Rule> rules = HashMultiset.create();
    private Multiset<RulePriority> severities = HashMultiset.create();
    private Map<Rule, RulePriority> ruleToSeverity = Maps.newHashMap();
    private int total = 0;

    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    @DependedUpon
    public List<Metric> generatesViolationsMetrics() {
        return Arrays.asList(CoreMetrics.VIOLATIONS, CoreMetrics.BLOCKER_VIOLATIONS, CoreMetrics.CRITICAL_VIOLATIONS, CoreMetrics.MAJOR_VIOLATIONS, CoreMetrics.MINOR_VIOLATIONS, CoreMetrics.INFO_VIOLATIONS);
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (this.shouldDecorateResource(resource)) {
            this.resetCounters();
            this.countViolations(context);
            this.saveTotalViolations(context);
            this.saveViolationsBySeverity(context);
            this.saveViolationsByRule(context);
        }
    }

    private boolean shouldDecorateResource(Resource resource) {
        return !ResourceUtils.isUnitTestClass((Resource)resource);
    }

    private void resetCounters() {
        this.rules.clear();
        this.severities.clear();
        this.ruleToSeverity.clear();
        this.total = 0;
    }

    private void saveViolationsBySeverity(DecoratorContext context) {
        for (RulePriority severity : RulePriority.values()) {
            Metric metric = this.getMetricForSeverity(severity);
            if (context.getMeasure(metric) != null) continue;
            Collection children = context.getChildrenMeasures(MeasuresFilters.metric((Metric)metric));
            double sum = MeasureUtils.sum((boolean)true, (Collection)children) + (double)this.severities.count((Object)severity);
            context.saveMeasure(new Measure(metric, Double.valueOf(sum)));
        }
    }

    private Metric getMetricForSeverity(RulePriority severity) {
        Metric metric = null;
        if (severity.equals((Object)RulePriority.BLOCKER)) {
            metric = CoreMetrics.BLOCKER_VIOLATIONS;
        } else if (severity.equals((Object)RulePriority.CRITICAL)) {
            metric = CoreMetrics.CRITICAL_VIOLATIONS;
        } else if (severity.equals((Object)RulePriority.MAJOR)) {
            metric = CoreMetrics.MAJOR_VIOLATIONS;
        } else if (severity.equals((Object)RulePriority.MINOR)) {
            metric = CoreMetrics.MINOR_VIOLATIONS;
        } else if (severity.equals((Object)RulePriority.INFO)) {
            metric = CoreMetrics.INFO_VIOLATIONS;
        }
        return metric;
    }

    private void saveViolationsByRule(DecoratorContext context) {
        Collection children = context.getChildrenMeasures(MeasuresFilters.rules((Metric)CoreMetrics.VIOLATIONS));
        for (Measure childMeasure : children) {
            RuleMeasure childRuleMeasure = (RuleMeasure)childMeasure;
            Rule rule = childRuleMeasure.getRule();
            if (rule == null || !MeasureUtils.hasValue((Measure)childRuleMeasure)) continue;
            this.rules.add((Object)rule, childRuleMeasure.getValue().intValue());
            this.ruleToSeverity.put(childRuleMeasure.getRule(), childRuleMeasure.getRulePriority());
        }
        for (Multiset.Entry entry : this.rules.entrySet()) {
            Rule rule = (Rule)entry.getElement();
            RuleMeasure measure = RuleMeasure.createForRule((Metric)CoreMetrics.VIOLATIONS, (Rule)rule, (Double)Double.valueOf(entry.getCount()));
            measure.setRulePriority(this.ruleToSeverity.get(rule));
            context.saveMeasure((Measure)measure);
        }
    }

    private void saveTotalViolations(DecoratorContext context) {
        if (context.getMeasure(CoreMetrics.VIOLATIONS) == null) {
            Collection childrenViolations = context.getChildrenMeasures(CoreMetrics.VIOLATIONS);
            Double sum = MeasureUtils.sum((boolean)true, (Collection)childrenViolations) + (double)this.total;
            context.saveMeasure(new Measure(CoreMetrics.VIOLATIONS, sum));
        }
    }

    private void countViolations(DecoratorContext context) {
        List violations = context.getViolations();
        for (Violation violation : violations) {
            this.rules.add((Object)violation.getRule());
            this.severities.add((Object)violation.getSeverity());
            this.ruleToSeverity.put(violation.getRule(), violation.getSeverity());
        }
        this.total = violations.size();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

