/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.sensors;

import java.util.Date;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.sonar.api.batch.Event;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;

public class VersionEventsSensor
implements Sensor {
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";

    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    public void analyse(Project project, SensorContext context) {
        if (StringUtils.isBlank((String)project.getAnalysisVersion())) {
            return;
        }
        this.deleteDeprecatedEvents(project, context);
        context.createEvent((Resource)project, project.getAnalysisVersion(), null, "Version", null);
    }

    private void deleteDeprecatedEvents(Project project, SensorContext context) {
        String version = project.getAnalysisVersion();
        String snapshotVersionToDelete = version.endsWith(SNAPSHOT_SUFFIX) ? "" : version + SNAPSHOT_SUFFIX;
        Iterator it = context.getEvents((Resource)project).iterator();
        while (it.hasNext()) {
            Event event = (Event)it.next();
            if (event.isVersionCategory() && (version.equals(event.getName()) || snapshotVersionToDelete.equals(event.getName()))) {
                it.remove();
                context.deleteEvent(event);
                event = null;
            }
            if (event == null || event.isLinkedToSnapshot() || event.getDate() == null || project.getAnalysisDate() == null || !DateUtils.isSameDay((Date)event.getDate(), (Date)project.getAnalysisDate())) continue;
            it.remove();
            context.deleteEvent(event);
            context.createEvent((Resource)project, event.getName(), event.getDescription(), event.getCategory(), null);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

