/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.sensors;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitTestDecorator
implements Decorator {
    @DependedUpon
    public List<Metric> generatesMetrics() {
        return Arrays.asList(CoreMetrics.TEST_EXECUTION_TIME, CoreMetrics.TESTS, CoreMetrics.TEST_ERRORS, CoreMetrics.TEST_FAILURES, CoreMetrics.TEST_SUCCESS_DENSITY);
    }

    public boolean shouldExecuteOnProject(Project project) {
        return !Project.AnalysisType.STATIC.equals((Object)project.getAnalysisType());
    }

    public boolean shouldDecorateResource(Resource resource, DecoratorContext context) {
        return context.getMeasure(CoreMetrics.TESTS) == null && (ResourceUtils.isUnitTestClass((Resource)resource) || !ResourceUtils.isEntity((Resource)resource));
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (this.shouldDecorateResource(resource, context)) {
            this.sumChildren(context, CoreMetrics.TEST_EXECUTION_TIME);
            this.sumChildren(context, CoreMetrics.SKIPPED_TESTS);
            Double tests = this.sumChildren(context, CoreMetrics.TESTS);
            Double errors = this.sumChildren(context, CoreMetrics.TEST_ERRORS);
            Double failures = this.sumChildren(context, CoreMetrics.TEST_FAILURES);
            if (this.isPositive(tests, true) && this.isPositive(errors, false) && this.isPositive(failures, false)) {
                Double errorsAndFailuresRatio = (errors + failures) * 100.0 / tests;
                context.saveMeasure(CoreMetrics.TEST_SUCCESS_DENSITY, Double.valueOf(100.0 - errorsAndFailuresRatio));
            }
        }
    }

    private boolean isPositive(Double d, boolean strict) {
        return d != null && (strict ? d > 0.0 : d >= 0.0);
    }

    private Double sumChildren(DecoratorContext jobContext, Metric metric) {
        Collection childrenMeasures = jobContext.getChildrenMeasures(metric);
        if (childrenMeasures != null && childrenMeasures.size() > 0) {
            Double sum = 0.0;
            boolean hasChildrenMeasures = false;
            for (Measure measure : childrenMeasures) {
                if (!MeasureUtils.hasValue((Measure)measure)) continue;
                sum = sum + measure.getValue();
                hasChildrenMeasures = true;
            }
            if (hasChildrenMeasures) {
                jobContext.saveMeasure(metric, sum);
                return sum;
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

