/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.sensors;

import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.SupportedEnvironment;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.ProjectLink;

@SupportedEnvironment(value={"maven"})
public class ProjectLinksSensor
implements Sensor {
    public static final String KEY_HOME = "homepage";
    public static final String KEY_CONTINUOUS_INTEGRATION = "ci";
    public static final String KEY_ISSUE_TRACKER = "issue";
    public static final String KEY_SCM = "scm";
    public static final String KEY_SCM_DEVELOPER_CONNECTION = "scm_dev";
    private MavenProject pom;

    public ProjectLinksSensor(MavenProject pom) {
        this.pom = pom;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    public void analyse(Project project, SensorContext context) {
        this.updateLink(context, KEY_HOME, "Home", this.pom.getUrl());
        Scm scm = this.pom.getScm();
        if (scm == null) {
            scm = new Scm();
        }
        this.updateLink(context, KEY_SCM, "Sources", scm.getUrl());
        this.updateLink(context, KEY_SCM_DEVELOPER_CONNECTION, "Developer connection", scm.getDeveloperConnection());
        CiManagement ci = this.pom.getCiManagement();
        if (ci == null) {
            ci = new CiManagement();
        }
        this.updateLink(context, KEY_CONTINUOUS_INTEGRATION, "Continuous integration", ci.getUrl());
        IssueManagement issues = this.pom.getIssueManagement();
        if (issues == null) {
            issues = new IssueManagement();
        }
        this.updateLink(context, KEY_ISSUE_TRACKER, "Issues", issues.getUrl());
    }

    private void updateLink(SensorContext context, String key, String name, String url) {
        if (StringUtils.isBlank((String)url)) {
            context.deleteLink(key);
        } else {
            context.saveLink(new ProjectLink(key, name, url));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

