/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.sensors;

import java.util.List;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.TimeMachine;
import org.sonar.api.batch.TimeMachineQuery;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;

public class GenerateAlertEvents
implements Decorator {
    private final RulesProfile profile;
    private final TimeMachine timeMachine;

    public GenerateAlertEvents(RulesProfile profile, TimeMachine timeMachine) {
        this.profile = profile;
        this.timeMachine = timeMachine;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.profile != null && this.profile.getAlerts() != null && this.profile.getAlerts().size() > 0;
    }

    @DependsUpon
    public Metric dependsUponAlertStatus() {
        return CoreMetrics.ALERT_STATUS;
    }

    public void decorate(Resource resource, DecoratorContext context) {
        Measure pastStatus;
        if (!this.shouldDecorateResource(resource)) {
            return;
        }
        Measure currentStatus = context.getMeasure(CoreMetrics.ALERT_STATUS);
        if (currentStatus == null) {
            return;
        }
        TimeMachineQuery query = new TimeMachineQuery(resource).setOnlyLastAnalysis(true).setMetrics(new Metric[]{CoreMetrics.ALERT_STATUS});
        List measures = this.timeMachine.getMeasures(query);
        Measure measure = pastStatus = measures != null && measures.size() == 1 ? (Measure)measures.get(0) : null;
        if (pastStatus != null && pastStatus.getDataAsLevel() != currentStatus.getDataAsLevel()) {
            this.createEvent(context, this.getName(pastStatus, currentStatus), currentStatus.getAlertText());
        } else if (pastStatus == null && currentStatus.getDataAsLevel() != Metric.Level.OK) {
            this.createEvent(context, this.getName(currentStatus), currentStatus.getAlertText());
        }
    }

    private boolean shouldDecorateResource(Resource resource) {
        return ResourceUtils.isRootProject((Resource)resource);
    }

    private String getName(Measure pastStatus, Measure currentStatus) {
        return this.getName(currentStatus) + " (was " + this.getName(pastStatus) + ")";
    }

    private String getName(Measure currentStatus) {
        return currentStatus.getDataAsLevel().getColorName();
    }

    private void createEvent(DecoratorContext context, String name, String description) {
        context.createEvent(name, description, "Alert", null);
    }
}

