/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.sensors;

import java.util.Collection;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;

public final class FilesDecorator
implements Decorator {
    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    @DependedUpon
    public Metric generateDirectoriesMetric() {
        return CoreMetrics.FILES;
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (MeasureUtils.hasValue((Measure)context.getMeasure(CoreMetrics.FILES))) {
            return;
        }
        if ("CLA".equals(resource.getQualifier()) || "FIL".equals(resource.getQualifier())) {
            context.saveMeasure(CoreMetrics.FILES, Double.valueOf(1.0));
        } else {
            Collection childrenMeasures = context.getChildrenMeasures(CoreMetrics.FILES);
            Double sum = MeasureUtils.sum((boolean)false, (Collection)childrenMeasures);
            if (sum != null) {
                context.saveMeasure(CoreMetrics.FILES, sum);
            }
        }
    }
}

