/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.sensors;

import java.util.Collection;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;

public final class DirectoriesDecorator
implements Decorator {
    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    @DependedUpon
    public Metric generateDirectoriesMetric() {
        return CoreMetrics.DIRECTORIES;
    }

    public void decorate(Resource resource, DecoratorContext context) {
        Collection childrenMeasures;
        Double sum;
        if (MeasureUtils.hasValue((Measure)context.getMeasure(CoreMetrics.DIRECTORIES))) {
            return;
        }
        if ("DIR".equals(resource.getQualifier())) {
            context.saveMeasure(CoreMetrics.DIRECTORIES, Double.valueOf(1.0));
        } else if ((ResourceUtils.isSet((Resource)resource) || ResourceUtils.isView((Resource)resource) || ResourceUtils.isSubview((Resource)resource)) && (sum = MeasureUtils.sum((boolean)false, (Collection)(childrenMeasures = context.getChildrenMeasures(CoreMetrics.DIRECTORIES)))) != null) {
            context.saveMeasure(CoreMetrics.DIRECTORIES, sum);
        }
    }
}

