/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.sensors;

import java.util.Arrays;
import java.util.Collection;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.plugins.core.sensors.AbstractCoverageDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CoverageDecorator
extends AbstractCoverageDecorator {
    @DependsUpon
    public Collection<Metric> usedMetrics() {
        return Arrays.asList(CoreMetrics.LINES_TO_COVER, CoreMetrics.UNCOVERED_LINES, CoreMetrics.NEW_LINES_TO_COVER, CoreMetrics.NEW_UNCOVERED_LINES, CoreMetrics.CONDITIONS_TO_COVER, CoreMetrics.UNCOVERED_CONDITIONS, CoreMetrics.NEW_CONDITIONS_TO_COVER, CoreMetrics.NEW_UNCOVERED_CONDITIONS);
    }

    @Override
    protected Metric getGeneratedMetric() {
        return CoreMetrics.COVERAGE;
    }

    @Override
    protected Long countElements(DecoratorContext context) {
        long lines = MeasureUtils.getValueAsLong((Measure)context.getMeasure(CoreMetrics.LINES_TO_COVER), (Long)0L);
        long conditions = MeasureUtils.getValueAsLong((Measure)context.getMeasure(CoreMetrics.CONDITIONS_TO_COVER), (Long)0L);
        return lines + conditions;
    }

    @Override
    protected long countCoveredElements(DecoratorContext context) {
        long uncoveredLines = MeasureUtils.getValueAsLong((Measure)context.getMeasure(CoreMetrics.UNCOVERED_LINES), (Long)0L);
        long lines = MeasureUtils.getValueAsLong((Measure)context.getMeasure(CoreMetrics.LINES_TO_COVER), (Long)0L);
        long uncoveredConditions = MeasureUtils.getValueAsLong((Measure)context.getMeasure(CoreMetrics.UNCOVERED_CONDITIONS), (Long)0L);
        long conditions = MeasureUtils.getValueAsLong((Measure)context.getMeasure(CoreMetrics.CONDITIONS_TO_COVER), (Long)0L);
        return lines + conditions - uncoveredConditions - uncoveredLines;
    }

    @Override
    protected Metric getGeneratedMetricForNewCode() {
        return CoreMetrics.NEW_COVERAGE;
    }

    @Override
    protected Long countElementsForNewCode(DecoratorContext context, int periodIndex) {
        Long newLinesToCover = MeasureUtils.getVariationAsLong((Measure)context.getMeasure(CoreMetrics.NEW_LINES_TO_COVER), (int)periodIndex);
        if (newLinesToCover != null) {
            long newConditionsToCover = MeasureUtils.getVariationAsLong((Measure)context.getMeasure(CoreMetrics.NEW_CONDITIONS_TO_COVER), (int)periodIndex, (Long)0L);
            return newLinesToCover + newConditionsToCover;
        }
        return null;
    }

    @Override
    protected long countCoveredElementsForNewCode(DecoratorContext context, int periodIndex) {
        long newLines = MeasureUtils.getVariationAsLong((Measure)context.getMeasure(CoreMetrics.NEW_LINES_TO_COVER), (int)periodIndex, (Long)0L);
        long newUncoveredLines = MeasureUtils.getVariationAsLong((Measure)context.getMeasure(CoreMetrics.NEW_UNCOVERED_LINES), (int)periodIndex, (Long)0L);
        long newUncoveredConditions = MeasureUtils.getVariationAsLong((Measure)context.getMeasure(CoreMetrics.NEW_UNCOVERED_CONDITIONS), (int)periodIndex, (Long)0L);
        long newConditions = MeasureUtils.getVariationAsLong((Measure)context.getMeasure(CoreMetrics.NEW_CONDITIONS_TO_COVER), (int)periodIndex, (Long)0L);
        return newLines + newConditions - newUncoveredConditions - newUncoveredLines;
    }
}

