/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.sensors;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentDensityDecorator
implements Decorator {
    @DependsUpon
    public List<Metric> dependsUponMetrics() {
        return Arrays.asList(CoreMetrics.NCLOC, CoreMetrics.COMMENT_LINES, CoreMetrics.PUBLIC_API, CoreMetrics.PUBLIC_UNDOCUMENTED_API);
    }

    @DependedUpon
    public List<Metric> generatesMetrics() {
        return Arrays.asList(CoreMetrics.COMMENT_LINES_DENSITY, CoreMetrics.PUBLIC_DOCUMENTED_API_DENSITY);
    }

    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    public void decorate(Resource resource, DecoratorContext context) {
        this.saveCommentsDensity(context);
        this.savePublicApiDensity(context);
    }

    private void saveCommentsDensity(DecoratorContext context) {
        if (context.getMeasure(CoreMetrics.COMMENT_LINES_DENSITY) != null) {
            return;
        }
        Measure ncloc = context.getMeasure(CoreMetrics.NCLOC);
        Measure comments = context.getMeasure(CoreMetrics.COMMENT_LINES);
        if (MeasureUtils.hasValue((Measure)ncloc) && MeasureUtils.hasValue((Measure)comments) && comments.getValue() + ncloc.getValue() > 0.0) {
            double val = 100.0 * (comments.getValue() / (comments.getValue() + ncloc.getValue()));
            context.saveMeasure(new Measure(CoreMetrics.COMMENT_LINES_DENSITY, Double.valueOf(val)));
        }
    }

    private void savePublicApiDensity(DecoratorContext context) {
        if (context.getMeasure(CoreMetrics.PUBLIC_DOCUMENTED_API_DENSITY) != null) {
            return;
        }
        Measure publicApi = context.getMeasure(CoreMetrics.PUBLIC_API);
        Measure publicUndocApi = context.getMeasure(CoreMetrics.PUBLIC_UNDOCUMENTED_API);
        if (MeasureUtils.hasValue((Measure)publicApi) && MeasureUtils.hasValue((Measure)publicUndocApi) && publicApi.getValue() > 0.0) {
            double documentedAPI = publicApi.getValue() - publicUndocApi.getValue();
            Double value = 100.0 * (documentedAPI / publicApi.getValue());
            context.saveMeasure(new Measure(CoreMetrics.PUBLIC_DOCUMENTED_API_DENSITY, value));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

