/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.sensors;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.profiles.Alert;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.plugins.core.sensors.AlertUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckAlertThresholds
implements Decorator {
    private final RulesProfile profile;

    public CheckAlertThresholds(RulesProfile profile) {
        this.profile = profile;
    }

    @DependedUpon
    public Metric generatesAlertStatus() {
        return CoreMetrics.ALERT_STATUS;
    }

    @DependsUpon
    public List<Metric> dependsUponMetrics() {
        LinkedList metrics = Lists.newLinkedList();
        for (Alert alert : this.profile.getAlerts()) {
            metrics.add(alert.getMetric());
        }
        return metrics;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.profile != null && this.profile.getAlerts() != null && this.profile.getAlerts().size() > 0 && ResourceUtils.isRootProject((Resource)project);
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (this.shouldDecorateResource(resource)) {
            this.decorateResource(context);
        }
    }

    private void decorateResource(DecoratorContext context) {
        Metric.Level globalLevel = Metric.Level.OK;
        ArrayList labels = Lists.newArrayList();
        for (Alert alert : this.profile.getAlerts()) {
            Measure measure = context.getMeasure(alert.getMetric());
            if (measure == null) continue;
            Metric.Level level = AlertUtils.getLevel(alert, measure);
            measure.setAlertStatus(level);
            String text = this.getText(alert, level);
            if (!StringUtils.isBlank((String)text)) {
                measure.setAlertText(text);
                labels.add(text);
            }
            context.saveMeasure(measure);
            if (Metric.Level.WARN == level && globalLevel != Metric.Level.ERROR) {
                globalLevel = Metric.Level.WARN;
                continue;
            }
            if (Metric.Level.ERROR != level) continue;
            globalLevel = Metric.Level.ERROR;
        }
        Measure globalMeasure = new Measure(CoreMetrics.ALERT_STATUS, globalLevel);
        globalMeasure.setAlertStatus(globalLevel);
        globalMeasure.setAlertText(StringUtils.join((Collection)labels, (String)", "));
        context.saveMeasure(globalMeasure);
    }

    private boolean shouldDecorateResource(Resource resource) {
        return ResourceUtils.isRootProject((Resource)resource);
    }

    private String getText(Alert alert, Metric.Level level) {
        if (level == Metric.Level.OK) {
            return null;
        }
        return alert.getAlertLabel(level);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

