/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.sensors;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.plugins.core.sensors.AbstractCoverageDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BranchCoverageDecorator
extends AbstractCoverageDecorator {
    @DependsUpon
    public List<Metric> dependsUponMetrics() {
        return Arrays.asList(CoreMetrics.UNCOVERED_CONDITIONS, CoreMetrics.CONDITIONS_TO_COVER, CoreMetrics.NEW_UNCOVERED_CONDITIONS, CoreMetrics.NEW_CONDITIONS_TO_COVER);
    }

    @Override
    protected Metric getGeneratedMetric() {
        return CoreMetrics.BRANCH_COVERAGE;
    }

    @Override
    protected Long countElements(DecoratorContext context) {
        return MeasureUtils.getValueAsLong((Measure)context.getMeasure(CoreMetrics.CONDITIONS_TO_COVER), (Long)0L);
    }

    @Override
    protected long countCoveredElements(DecoratorContext context) {
        long uncoveredConditions = MeasureUtils.getValueAsLong((Measure)context.getMeasure(CoreMetrics.UNCOVERED_CONDITIONS), (Long)0L);
        long conditions = MeasureUtils.getValueAsLong((Measure)context.getMeasure(CoreMetrics.CONDITIONS_TO_COVER), (Long)0L);
        return conditions - uncoveredConditions;
    }

    @Override
    protected Metric getGeneratedMetricForNewCode() {
        return CoreMetrics.NEW_BRANCH_COVERAGE;
    }

    @Override
    protected Long countElementsForNewCode(DecoratorContext context, int periodIndex) {
        return MeasureUtils.getVariationAsLong((Measure)context.getMeasure(CoreMetrics.NEW_CONDITIONS_TO_COVER), (int)periodIndex);
    }

    @Override
    protected long countCoveredElementsForNewCode(DecoratorContext context, int periodIndex) {
        long uncoveredConditions = MeasureUtils.getVariationAsLong((Measure)context.getMeasure(CoreMetrics.NEW_UNCOVERED_CONDITIONS), (int)periodIndex, (Long)0L);
        long conditions = MeasureUtils.getVariationAsLong((Measure)context.getMeasure(CoreMetrics.NEW_CONDITIONS_TO_COVER), (int)periodIndex, (Long)0L);
        return conditions - uncoveredConditions;
    }
}

