/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.sensors;

import org.sonar.api.batch.Phase;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.jpa.dao.AsyncMeasuresService;

@Phase(name=Phase.Name.PRE)
public class AsynchronousMeasuresSensor
implements Sensor {
    private AsyncMeasuresService reviewsService;
    private Snapshot snapshot;

    public AsynchronousMeasuresSensor(AsyncMeasuresService reviewsService, Snapshot snapshot) {
        this.reviewsService = reviewsService;
        this.snapshot = snapshot;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    public void analyse(Project project, SensorContext context) {
        if (!ResourceUtils.isRootProject((Resource)project)) {
            return;
        }
        this.reviewsService.refresh(this.snapshot);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

