/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.sensors;

import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.profiles.Alert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AlertUtils {
    private AlertUtils() {
    }

    public static Metric.Level getLevel(Alert alert, Measure measure) {
        if (AlertUtils.evaluateAlert(alert, measure, Metric.Level.ERROR)) {
            return Metric.Level.ERROR;
        }
        if (AlertUtils.evaluateAlert(alert, measure, Metric.Level.WARN)) {
            return Metric.Level.WARN;
        }
        return Metric.Level.OK;
    }

    private static boolean evaluateAlert(Alert alert, Measure measure, Metric.Level alertLevel) {
        String valueToEval;
        if (alertLevel.equals((Object)Metric.Level.ERROR)) {
            valueToEval = alert.getValueError();
        } else if (alertLevel.equals((Object)Metric.Level.WARN)) {
            valueToEval = alert.getValueWarning();
        } else {
            throw new IllegalStateException(alertLevel.toString());
        }
        if (StringUtils.isEmpty((String)valueToEval)) {
            return false;
        }
        Comparable<?> criteriaValue = AlertUtils.getValueForComparison(alert.getMetric(), valueToEval);
        Comparable<?> metricValue = AlertUtils.getMeasureValue(alert.getMetric(), measure);
        int comparison = metricValue.compareTo(criteriaValue);
        return !(alert.isNotEqualsOperator() && comparison == 0 || alert.isGreaterOperator() && comparison != 1 || alert.isSmallerOperator() && comparison != -1) && (!alert.isEqualsOperator() || comparison == 0);
    }

    private static Comparable<?> getValueForComparison(Metric metric, String value) {
        if (metric.getType() == Metric.ValueType.FLOAT || metric.getType() == Metric.ValueType.PERCENT) {
            return Double.parseDouble(value);
        }
        if (metric.getType() == Metric.ValueType.INT || metric.getType() == Metric.ValueType.MILLISEC) {
            return value.contains(".") ? Integer.parseInt(value.substring(0, value.indexOf(46))) : Integer.parseInt(value);
        }
        if (metric.getType() == Metric.ValueType.STRING || metric.getType() == Metric.ValueType.LEVEL) {
            return value;
        }
        if (metric.getType() == Metric.ValueType.BOOL) {
            return Boolean.valueOf(value);
        }
        if (metric.getType() == Metric.ValueType.RATING) {
            return Double.parseDouble(value);
        }
        throw new NotImplementedException(metric.getType().toString());
    }

    private static Comparable<?> getMeasureValue(Metric metric, Measure measure) {
        if (metric.getType() == Metric.ValueType.FLOAT || metric.getType() == Metric.ValueType.PERCENT) {
            return measure.getValue();
        }
        if (metric.getType() == Metric.ValueType.INT || metric.getType() == Metric.ValueType.MILLISEC) {
            return measure.getValue().intValue();
        }
        if (metric.getType() == Metric.ValueType.STRING || metric.getType() == Metric.ValueType.LEVEL) {
            return measure.getData();
        }
        if (metric.getType() == Metric.ValueType.BOOL) {
            return measure.getValue() == 0.0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (metric.getType() == Metric.ValueType.RATING) {
            return measure.getValue();
        }
        throw new NotImplementedException(metric.getType().toString());
    }
}

