/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.sensors;

import java.util.Arrays;
import java.util.Collection;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCoverageDecorator
implements Decorator {
    public boolean shouldExecuteOnProject(Project project) {
        return project.getAnalysisType().isDynamic(true);
    }

    @DependedUpon
    public Collection<Metric> generatedMetrics() {
        return Arrays.asList(this.getGeneratedMetric(), this.getGeneratedMetricForNewCode());
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (this.shouldDecorate(resource, context)) {
            this.computeMeasure(context);
            this.computeMeasureForNewCode(context);
        }
    }

    protected boolean shouldDecorate(Resource resource, DecoratorContext context) {
        return !ResourceUtils.isUnitTestClass((Resource)resource);
    }

    private void computeMeasure(DecoratorContext context) {
        Long elements;
        if (context.getMeasure(this.getGeneratedMetric()) == null && (elements = this.countElements(context)) != null && elements > 0L) {
            Long coveredElements = this.countCoveredElements(context);
            context.saveMeasure(this.getGeneratedMetric(), Double.valueOf(this.calculateCoverage(coveredElements, elements)));
        }
    }

    private void computeMeasureForNewCode(DecoratorContext context) {
        if (context.getMeasure(this.getGeneratedMetricForNewCode()) == null) {
            Measure measure = new Measure(this.getGeneratedMetricForNewCode());
            boolean hasValue = false;
            for (int periodIndex = 1; periodIndex <= 5; ++periodIndex) {
                Long elements = this.countElementsForNewCode(context, periodIndex);
                if (elements == null || elements <= 0L) continue;
                long coveredElements = this.countCoveredElementsForNewCode(context, periodIndex);
                measure.setVariation(periodIndex, Double.valueOf(this.calculateCoverage(coveredElements, elements)));
                hasValue = true;
            }
            if (hasValue) {
                context.saveMeasure(measure);
            }
        }
    }

    private double calculateCoverage(long coveredLines, long lines) {
        return 100.0 * (double)coveredLines / (double)lines;
    }

    protected abstract Metric getGeneratedMetric();

    protected abstract Long countElements(DecoratorContext var1);

    protected abstract long countCoveredElements(DecoratorContext var1);

    protected abstract Metric getGeneratedMetricForNewCode();

    protected abstract Long countElementsForNewCode(DecoratorContext var1, int var2);

    protected abstract long countCoveredElementsForNewCode(DecoratorContext var1, int var2);
}

