/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.security;

import java.util.List;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.security.GroupRole;
import org.sonar.api.security.UserRole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleManager {
    protected static final String DEFAULT_ROLE_PREFIX = "default-";
    private DatabaseSession session;

    public RoleManager(DatabaseSession session) {
        this.session = session;
    }

    public void affectDefaultRolesToResource(int resourceId) {
        for (UserRole userRole : this.getDefaultUserRoles()) {
            this.session.save((Object)this.createResourceRoleFromDefault(userRole, resourceId));
        }
        for (GroupRole groupRole : this.getDefaultGroupRoles()) {
            this.session.save((Object)this.createResourceRoleFromDefault(groupRole, resourceId));
        }
        this.session.commit();
    }

    public List<UserRole> getUserRoles(int resourceId) {
        return this.session.getResults(UserRole.class, new Object[]{"resourceId", resourceId});
    }

    public List<GroupRole> getGroupRoles(int resourceId) {
        return this.session.getResults(GroupRole.class, new Object[]{"resourceId", resourceId});
    }

    protected List<UserRole> getDefaultUserRoles() {
        Query query = this.session.createQuery("from " + UserRole.class.getSimpleName() + " ur where ur.resourceId is null and ur.role like '" + DEFAULT_ROLE_PREFIX + "%'");
        return query.getResultList();
    }

    protected List<GroupRole> getDefaultGroupRoles() {
        Query query = this.session.createQuery("from " + GroupRole.class.getSimpleName() + " gr where gr.resourceId is null and gr.role like '" + DEFAULT_ROLE_PREFIX + "%'");
        return query.getResultList();
    }

    protected UserRole createResourceRoleFromDefault(UserRole defaultUserRole, int resourceId) {
        UserRole result = new UserRole();
        result.setRole(RoleManager.convertDefaultRoleName(defaultUserRole.getRole()));
        result.setResourceId(Integer.valueOf(resourceId));
        result.setUserId(defaultUserRole.getUserId());
        return result;
    }

    protected GroupRole createResourceRoleFromDefault(GroupRole defaultUserRole, int resourceId) {
        GroupRole result = new GroupRole();
        result.setRole(RoleManager.convertDefaultRoleName(defaultUserRole.getRole()));
        result.setResourceId(Integer.valueOf(resourceId));
        result.setGroupId(defaultUserRole.getGroupId());
        return result;
    }

    protected static String convertDefaultRoleName(String defaultRoleName) {
        return StringUtils.substringAfter((String)defaultRoleName, (String)DEFAULT_ROLE_PREFIX);
    }
}

