/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.security;

import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.core.security.RoleManager;

public class ApplyProjectRolesDecorator
implements Decorator {
    private RoleManager roleManager;

    protected ApplyProjectRolesDecorator(RoleManager roleManager) {
        this.roleManager = roleManager;
    }

    public ApplyProjectRolesDecorator(DatabaseSession session) {
        this.roleManager = new RoleManager(session);
    }

    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (this.shouldDecorateResource(resource)) {
            Project project = (Project)resource;
            this.roleManager.affectDefaultRolesToResource(project.getId());
        }
    }

    private boolean shouldDecorateResource(Resource resource) {
        if (this.isProject(resource)) {
            Project project = (Project)resource;
            return project.getId() != null && this.countRoles(project.getId()) == 0;
        }
        return false;
    }

    private boolean isProject(Resource resource) {
        if ("TRK".equals(resource.getQualifier()) || "VW".equals(resource.getQualifier()) || "SVW".equals(resource.getQualifier())) {
            return resource instanceof Project;
        }
        return false;
    }

    private int countRoles(int resourceId) {
        return this.roleManager.getUserRoles(resourceId).size() + this.roleManager.getGroupRoles(resourceId).size();
    }
}

