/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.hotspots.client.widget;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.sonar.gwt.Links;
import org.sonar.gwt.ui.Icons;
import org.sonar.plugins.core.hotspots.client.I18nConstants;
import org.sonar.plugins.core.hotspots.client.widget.AbstractHotspot;
import org.sonar.wsclient.gwt.AbstractCallback;
import org.sonar.wsclient.gwt.Callback;
import org.sonar.wsclient.gwt.Sonar;
import org.sonar.wsclient.services.Measure;
import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.Resource;
import org.sonar.wsclient.services.ResourceQuery;

public class MostViolatedRules
extends AbstractHotspot {
    private ListBox severity;

    public MostViolatedRules(Resource resource) {
        super("rules-hotspot", resource);
    }

    Widget createHeader() {
        this.severity = new ListBox(false);
        this.severity.addItem(I18nConstants.INSTANCE.anySeverity(), "");
        this.severity.addItem("Blocker", "BLOCKER");
        this.severity.addItem("Critical", "CRITICAL");
        this.severity.addItem("Major", "MAJOR");
        this.severity.addItem("Minor", "MINOR");
        this.severity.addItem("Info", "INFO");
        this.severity.setStyleName("small");
        this.severity.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                MostViolatedRules.this.loadData();
            }
        });
        Label label = new Label(I18nConstants.INSTANCE.titleMostViolatedRules());
        label.setStyleName("header");
        Anchor moreLink = new Anchor(I18nConstants.INSTANCE.moreDetails());
        moreLink.getElement().setId("more-rules");
        moreLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Window.Location.assign((String)(Links.baseUrl() + "/drilldown/violations/" + MostViolatedRules.this.getResource().getId()));
            }
        });
        HorizontalPanel horizontal = new HorizontalPanel();
        horizontal.setVerticalAlignment(HasAlignment.ALIGN_MIDDLE);
        horizontal.setWidth("98%");
        horizontal.add((Widget)label);
        horizontal.add((Widget)this.severity);
        horizontal.add((Widget)moreLink);
        horizontal.setCellHorizontalAlignment((Widget)label, HorizontalPanel.ALIGN_LEFT);
        horizontal.setCellHorizontalAlignment((Widget)this.severity, HorizontalPanel.ALIGN_LEFT);
        horizontal.setCellHorizontalAlignment((Widget)moreLink, HorizontalPanel.ALIGN_RIGHT);
        return horizontal;
    }

    void doLoadData() {
        ResourceQuery query = this.getResourceQuery();
        Sonar.getInstance().find((Query)query, (Callback)new AbstractCallback<Resource>(){

            protected void doOnResponse(Resource resource) {
                if (resource.getMeasures().isEmpty()) {
                    MostViolatedRules.this.renderEmptyResults();
                } else {
                    MostViolatedRules.this.renderGrid(resource);
                }
            }
        });
    }

    private void renderGrid(Resource resource) {
        Grid grid = new Grid(resource.getMeasures().size(), 4);
        grid.setStyleName("gwt-Hotspot");
        int row = 0;
        Measure firstMeasure = (Measure)resource.getMeasures().get(0);
        for (Measure measure : resource.getMeasures()) {
            this.renderRule(grid, measure, row);
            this.renderValueCell(grid, measure, row, 2);
            this.renderGraphCell(grid, measure, firstMeasure, row, 3);
            ++row;
        }
        this.render((Widget)grid);
    }

    protected void renderRule(Grid grid, final Measure measure, int row) {
        Anchor drillDown = new Anchor(measure.getRuleName());
        drillDown.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Window.Location.assign((String)(Links.baseUrl() + "/drilldown/violations/" + MostViolatedRules.this.getResource().getId() + "?rule=" + measure.getRuleKey()));
            }
        });
        grid.setWidget(row, 0, (Widget)new HTML("<a id=\"rule" + row + "\" href=\"" + Links.urlForRule((String)measure.getRuleKey(), (boolean)false) + "\" onclick=\"window.open(this.href,'rule','height=800,width=900,scrollbars=1,resizable=1');return false;\" title=\"" + measure.getRuleKey() + "\">" + Icons.forPriority((String)measure.getRulePriority()).getHTML() + "</a>"));
        grid.setWidget(row, 1, (Widget)drillDown);
        grid.getCellFormatter().setStyleName(row, 0, this.getRowCssClass(row) + "");
        grid.getCellFormatter().setStyleName(row, 1, this.getRowCssClass(row) + " resourceCell");
    }

    public ResourceQuery getResourceQuery() {
        ResourceQuery query = ResourceQuery.createForResource((Resource)this.getResource(), (String[])new String[]{"violations"}).setDepth(Integer.valueOf(0)).setExcludeRules(false).setLimit(Integer.valueOf(5));
        String priority = this.getSelectedPriority();
        if (priority != null) {
            query.setRulePriorities(new String[]{priority});
        }
        return query;
    }

    private String getSelectedPriority() {
        String priority = this.severity.getValue(this.severity.getSelectedIndex());
        if ("".equals(priority) || priority == null) {
            return null;
        }
        return priority;
    }
}

