/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.hotspots.client.widget;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Map;
import org.sonar.gwt.Links;
import org.sonar.gwt.ui.Icons;
import org.sonar.plugins.core.hotspots.client.I18nConstants;
import org.sonar.plugins.core.hotspots.client.widget.AbstractHotspot;
import org.sonar.wsclient.gwt.AbstractListCallback;
import org.sonar.wsclient.gwt.ListCallback;
import org.sonar.wsclient.gwt.Sonar;
import org.sonar.wsclient.services.Measure;
import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.Resource;
import org.sonar.wsclient.services.ResourceQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MostViolatedResources
extends AbstractHotspot {
    public MostViolatedResources(Resource resource) {
        super("violated-files-hotspot", resource);
    }

    @Override
    Widget createHeader() {
        Label label = new Label(I18nConstants.INSTANCE.titleMostViolatedResources());
        label.setStyleName("header");
        Anchor moreLink = new Anchor(I18nConstants.INSTANCE.moreDetails());
        moreLink.getElement().setId("more-violated-resources");
        moreLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Window.Location.assign((String)(Links.baseUrl() + "/drilldown/measures/" + MostViolatedResources.this.getResource().getId() + "?metric=" + "weighted_violations"));
            }
        });
        HorizontalPanel horizontal = new HorizontalPanel();
        horizontal.setVerticalAlignment(HasAlignment.ALIGN_MIDDLE);
        horizontal.setWidth("98%");
        horizontal.add((Widget)label);
        horizontal.add((Widget)moreLink);
        horizontal.setCellHorizontalAlignment((Widget)label, HorizontalPanel.ALIGN_LEFT);
        horizontal.setCellHorizontalAlignment((Widget)moreLink, HorizontalPanel.ALIGN_RIGHT);
        return horizontal;
    }

    @Override
    void doLoadData() {
        ResourceQuery query = this.getResourceQuery();
        Sonar.getInstance().findAll((Query)query, (ListCallback)new AbstractListCallback<Resource>(){

            protected void doOnResponse(List<Resource> resources) {
                Grid grid = new Grid(resources.size(), 11);
                grid.setStyleName("gwt-Hotspot");
                int row = 0;
                for (Resource resource : resources) {
                    if (resource.getMeasures().size() <= 0) continue;
                    MostViolatedResources.this.renderNameCell(grid, resource, "weighted_violations", row, 0);
                    MostViolatedResources.this.renderPriorities(grid, resource, row);
                    ++row;
                }
                if (row == 0) {
                    MostViolatedResources.this.renderEmptyResults();
                } else {
                    MostViolatedResources.this.render((Widget)grid);
                }
            }
        });
    }

    private void renderPriorities(Grid grid, Resource resource, int row) {
        Measure debt = (Measure)resource.getMeasures().get(0);
        if (debt != null && debt.getData() != null) {
            Map map = debt.getDataAsMap(";");
            this.renderSeverity(grid, row, map, 1, "BLOCKER");
            this.renderSeverity(grid, row, map, 3, "CRITICAL");
            this.renderSeverity(grid, row, map, 5, "MAJOR");
            this.renderSeverity(grid, row, map, 7, "MINOR");
            this.renderSeverity(grid, row, map, 9, "INFO");
        }
    }

    private void renderSeverity(Grid grid, int row, Map<String, String> map, int column, String severity) {
        grid.setWidget(row, column, (Widget)Icons.forPriority((String)severity).createImage());
        grid.getCellFormatter().setStyleName(row, column, this.getRowCssClass(row) + " small right");
        if (map.containsKey(severity)) {
            grid.setWidget(row, column + 1, (Widget)new HTML(map.get(severity)));
        } else {
            grid.setWidget(row, column + 1, (Widget)new HTML("0"));
        }
        grid.getCellFormatter().setStyleName(row, column + 1, this.getRowCssClass(row) + " small left");
    }

    private ResourceQuery getResourceQuery() {
        return ResourceQuery.createForResource((Resource)this.getResource(), (String[])new String[]{"weighted_violations"}).setScopes(new String[]{"FIL"}).setQualifiers(new String[]{"CLA", "FIL", "TRK"}).setDepth(Integer.valueOf(-1)).setLimit(Integer.valueOf(5));
    }
}

