/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.hotspots.client.widget;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.sonar.gwt.Links;
import org.sonar.plugins.core.hotspots.client.I18nConstants;
import org.sonar.plugins.core.hotspots.client.widget.AbstractHotspot;
import org.sonar.wsclient.gwt.AbstractListCallback;
import org.sonar.wsclient.gwt.ListCallback;
import org.sonar.wsclient.gwt.Sonar;
import org.sonar.wsclient.services.Measure;
import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.Resource;
import org.sonar.wsclient.services.ResourceQuery;

public class MetricHotspot
extends AbstractHotspot {
    private String metric;
    private String title;

    public MetricHotspot(Resource resource, String metric, String title) {
        super(metric + "-hotspot", resource);
        this.metric = metric;
        this.title = title;
    }

    Widget createHeader() {
        Label label = new Label(this.title);
        label.setStyleName("header");
        Anchor moreLink = new Anchor(I18nConstants.INSTANCE.moreDetails());
        moreLink.getElement().setId("more-" + this.metric);
        moreLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Window.Location.assign((String)(Links.baseUrl() + "/drilldown/measures/" + MetricHotspot.this.getResource().getKey() + "?metric=" + MetricHotspot.this.metric));
            }
        });
        HorizontalPanel horizontal = new HorizontalPanel();
        horizontal.setVerticalAlignment(HasAlignment.ALIGN_MIDDLE);
        horizontal.setWidth("98%");
        horizontal.add((Widget)label);
        horizontal.add((Widget)moreLink);
        horizontal.setCellHorizontalAlignment((Widget)label, HorizontalPanel.ALIGN_LEFT);
        horizontal.setCellHorizontalAlignment((Widget)moreLink, HorizontalPanel.ALIGN_RIGHT);
        return horizontal;
    }

    void doLoadData() {
        ResourceQuery query = this.getResourceQuery();
        Sonar.getInstance().findAll((Query)query, (ListCallback)new AbstractListCallback<Resource>(){

            protected void doOnResponse(List<Resource> resources) {
                ArrayList<HotspotMeasure> measures = new ArrayList<HotspotMeasure>();
                for (Resource resource : resources) {
                    for (Measure measure : resource.getMeasures()) {
                        measures.add(new HotspotMeasure(resource, measure));
                    }
                }
                if (measures.isEmpty()) {
                    MetricHotspot.this.renderEmptyResults();
                } else {
                    Grid grid = new Grid(measures.size(), 3);
                    grid.setStyleName("gwt-Hotspot");
                    int row = 0;
                    HotspotMeasure firstMeasure = (HotspotMeasure)measures.get(0);
                    for (HotspotMeasure measure : measures) {
                        MetricHotspot.this.renderNameCell(grid, measure.getResource(), MetricHotspot.this.metric, row, 0);
                        MetricHotspot.this.renderValueCell(grid, measure.getMeasure(), row, 1);
                        MetricHotspot.this.renderGraphCell(grid, measure.getMeasure(), firstMeasure.getMeasure(), row, 2);
                        ++row;
                    }
                    MetricHotspot.this.render((Widget)grid);
                }
            }
        });
    }

    protected ResourceQuery getResourceQuery() {
        return ResourceQuery.createForResource((Resource)this.getResource(), (String[])new String[]{this.metric}).setScopes(new String[]{"FIL"}).setDepth(Integer.valueOf(-1)).setLimit(Integer.valueOf(5));
    }

    public static class HotspotMeasure {
        private Resource resource;
        private Measure measure;

        public HotspotMeasure(Resource resource, Measure measure) {
            this.resource = resource;
            this.measure = measure;
        }

        public Resource getResource() {
            return this.resource;
        }

        public Measure getMeasure() {
            return this.measure;
        }
    }
}

