/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.hotspots.client.widget;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.sonar.gwt.Links;
import org.sonar.gwt.ui.Loading;
import org.sonar.plugins.core.hotspots.client.I18nConstants;
import org.sonar.wsclient.services.Measure;
import org.sonar.wsclient.services.Resource;

public abstract class AbstractHotspot
extends Composite {
    private Panel hotspot;
    private Panel data;
    private Resource resource;
    public static final int LIMIT = 5;

    protected AbstractHotspot(String id, Resource resource) {
        this.resource = resource;
        this.hotspot = new VerticalPanel();
        this.hotspot.getElement().setId(id);
        this.hotspot.setStyleName("gwt-HotspotPanel");
        this.initWidget((Widget)this.hotspot);
    }

    public Resource getResource() {
        return this.resource;
    }

    public void onLoad() {
        this.hotspot.add(this.createHeader());
        this.data = new SimplePanel();
        this.hotspot.add((Widget)this.data);
        this.loadData();
    }

    protected void loadData() {
        this.data.clear();
        this.data.add((Widget)new Loading());
        this.doLoadData();
    }

    abstract Widget createHeader();

    abstract void doLoadData();

    protected void render(Widget widget) {
        this.data.clear();
        this.data.add(widget);
    }

    protected void renderEmptyResults() {
        Grid grid = new Grid(1, 1);
        grid.setWidget(0, 0, (Widget)new HTML(I18nConstants.INSTANCE.noMeasures()));
        grid.getCellFormatter().setStyleName(0, 0, this.getRowCssClass(0) + " emptyResultsCell");
        grid.setStyleName("gwt-Hotspot");
        this.render((Widget)grid);
    }

    protected void renderNameCell(Grid hotspotGrid, final Resource resource, final String metricKey, int row, int column) {
        Anchor link = new Anchor(resource.getName());
        link.getElement().setAttribute("title", resource.getName(true));
        link.getElement().setAttribute("rel", resource.getName(true));
        link.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (resource.getCopy() != null) {
                    Window.Location.assign((String)(Links.baseUrl() + "/plugins/resource/" + resource.getCopy() + "?page=org.sonar.plugins.core.hotspots.GwtHotspots"));
                } else {
                    Links.openMeasurePopup((String)resource.getKey(), (String)metricKey);
                }
            }
        });
        hotspotGrid.setWidget(row, column, (Widget)link);
        hotspotGrid.getCellFormatter().setStyleName(row, column, this.getRowCssClass(row) + " resourceCell");
    }

    protected void renderValueCell(Grid hotspotGrid, Measure measure, int row, int column) {
        hotspotGrid.setHTML(row, column, measure.getFormattedValue());
        hotspotGrid.getCellFormatter().setStyleName(row, column, this.getRowCssClass(row) + " resultCell");
    }

    protected void renderGraphCell(Grid hotspotGrid, Measure measure, Measure firstMeasure, int row, int column) {
        Double value = (double)measure.getValue();
        Double upperValue = (double)firstMeasure.getValue();
        Double percentPonderated = this.getPercentPonderatedValue(value, 0.0, upperValue);
        String graph = "<span style='width:100%'><ul class='hbar' style='float: right;'><li style='background-color: rgb(119, 119, 119); width: " + percentPonderated.intValue() + "%'>&nbsp;</li></ul></span>";
        hotspotGrid.setHTML(row, column, graph);
        hotspotGrid.getCellFormatter().setStyleName(row, column, this.getRowCssClass(row) + " graphCell");
    }

    protected String getRowCssClass(int row) {
        return row % 2 == 0 ? "even" : "odd";
    }

    protected double getPercentPonderatedValue(Double value, Double lower, Double upper) {
        if (value < lower) {
            return 0.0;
        }
        if (value > upper) {
            return 100.0;
        }
        double percentIncrement = (upper - lower) / 100.0;
        return (value - lower) / percentIncrement;
    }
}

