/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.duplicationsviewer.client;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import org.sonar.gwt.ui.Page;
import org.sonar.gwt.ui.ViewerHeader;
import org.sonar.plugins.core.duplicationsviewer.client.DuplicationsPanel;
import org.sonar.wsclient.services.Measure;
import org.sonar.wsclient.services.Resource;

public class DuplicationsViewer
extends Page {
    public static final String GWT_ID = "org.sonar.plugins.core.duplicationsviewer.DuplicationsViewer";

    protected Widget doOnResourceLoad(Resource resource) {
        FlowPanel panel = new FlowPanel();
        panel.setWidth("100%");
        panel.add((Widget)new DuplicationsHeader(resource));
        panel.add((Widget)new DuplicationsPanel(resource));
        return panel;
    }

    private static class DuplicationsHeader
    extends ViewerHeader {
        public DuplicationsHeader(Resource resource) {
            super(resource, new String[]{"duplicated_lines_density", "lines", "duplicated_lines", "duplicated_blocks"});
        }

        protected void display(FlowPanel header, Resource resource) {
            HorizontalPanel panel = new HorizontalPanel();
            header.add((Widget)panel);
            Measure measure = resource.getMeasure("duplicated_lines_density");
            if (measure == null) {
                this.addBigCell((Panel)panel, "0");
            } else {
                this.addBigCell((Panel)panel, measure.getFormattedValue());
            }
            this.addCell((Panel)panel, new Measure[]{this.getDefaultMeasure(resource, "lines", "lines")});
            this.addCell((Panel)panel, new Measure[]{this.getDefaultMeasure(resource, "duplicated_lines", "Duplicated lines")});
            this.addCell((Panel)panel, new Measure[]{this.getDefaultMeasure(resource, "duplicated_blocks", "Duplicated blocks")});
        }

        private Measure getDefaultMeasure(Resource resource, String metric, String label) {
            Measure measure = resource.getMeasure(metric);
            if (measure == null || measure.getValue() == null) {
                measure = new Measure();
                measure.setMetricName(label);
                measure.setValue(Double.valueOf(0.0));
                measure.setFormattedValue("0");
            }
            return measure;
        }
    }
}

