/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.duplicationsviewer.client;

import com.google.gwt.gen2.table.override.client.FlexTable;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Element;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;
import org.sonar.gwt.ui.DefaultSourcePanel;
import org.sonar.gwt.ui.ExpandCollapseLink;
import org.sonar.gwt.ui.Loading;
import org.sonar.wsclient.gwt.AbstractCallback;
import org.sonar.wsclient.gwt.Callback;
import org.sonar.wsclient.gwt.Sonar;
import org.sonar.wsclient.services.Measure;
import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.Resource;
import org.sonar.wsclient.services.ResourceQuery;

public class DuplicationsPanel
extends Composite {
    private final Panel panel = new VerticalPanel();
    private Loading loading = new Loading();

    public DuplicationsPanel(Resource resource) {
        this.panel.add((Widget)this.loading);
        this.initWidget((Widget)this.panel);
        this.setStyleName("gwt-DuplicationsPanel");
        this.getElement().setId("gwt-DuplicationsPanel");
        this.loadDuplications(resource);
    }

    public void loadDuplications(Resource resource) {
        ResourceQuery query = ResourceQuery.createForResource((Resource)resource, (String[])new String[]{"duplications_data"});
        Sonar.getInstance().find((Query)query, (Callback)new DuplicationCallback());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DuplicationCallback
    extends AbstractCallback<Resource> {
        public DuplicationCallback() {
            super((Widget)DuplicationsPanel.this.loading);
        }

        protected void doOnResponse(Resource resource) {
            Measure data;
            DuplicationsPanel.this.loading.removeFromParent();
            String duplications = null;
            if (resource != null && (data = resource.getMeasure("duplications_data")) != null) {
                duplications = data.getData();
            }
            if (duplications != null) {
                this.processDuplications(duplications, resource);
            }
        }

        private void processDuplications(String duplicationXMLData, Resource resource) {
            Document parsed = XMLParser.parse((String)duplicationXMLData);
            NodeList duplicationsXML = parsed.getElementsByTagName("duplication");
            FlexTable table = this.getDuplicationsTable();
            DuplicationsPanel.this.panel.add((Widget)table);
            int rowCounter = 1;
            for (int i = 0; i < duplicationsXML.getLength(); ++i) {
                Element duplicationXML = (Element)duplicationsXML.item(i);
                String lines = duplicationXML.getAttribute("lines");
                String startLine = duplicationXML.getAttribute("start");
                String targetStartLine = duplicationXML.getAttribute("target-start");
                String targetResourceKey = duplicationXML.getAttribute("target-resource");
                this.renderDuplication(rowCounter, i, table, lines, startLine, targetStartLine, targetResourceKey, resource);
                rowCounter += 2;
            }
        }

        private FlexTable getDuplicationsTable() {
            FlexTable table = new FlexTable();
            table.setStylePrimaryName("duplicationsTable");
            table.setText(0, 0, "");
            table.setText(0, 1, "Nb lines");
            table.setText(0, 2, "From line");
            table.setText(0, 3, "File");
            table.setText(0, 4, "From line");
            table.getCellFormatter().getElement(0, 0).setId("expandCollapseCol");
            table.getCellFormatter().getElement(0, 1).setId("nbLineCol");
            table.getCellFormatter().getElement(0, 2).setId("lineFromCol");
            table.getCellFormatter().getElement(0, 3).setId("fileCol");
            this.setRowStyle(0, table, "header", false);
            return table;
        }

        private void renderDuplication(int row, int duplicationCounter, FlexTable table, String lines, String startLine, String targetStartLine, String targetResourceKey, Resource resource) {
            String style = duplicationCounter % 2 == 0 ? "odd" : "even";
            DefaultSourcePanel src = new DefaultSourcePanel(resource, new Integer(startLine).intValue(), new Integer(lines).intValue());
            src.getElement().setId("source-panel-" + targetResourceKey.replace('.', '_'));
            src.setVisible(false);
            ExpandCollapseLink link = new ExpandCollapseLink((Widget)src);
            table.setWidget(row, 0, (Widget)link);
            table.setText(row, 1, lines);
            table.setText(row, 2, startLine);
            if (targetResourceKey.equals(resource.getKey())) {
                targetResourceKey = "Same file";
            }
            if (targetResourceKey.contains(":")) {
                targetResourceKey = targetResourceKey.substring(targetResourceKey.lastIndexOf(58) + 1);
            }
            table.setText(row, 3, targetResourceKey);
            table.setText(row, 4, targetStartLine);
            this.setRowStyle(row, table, style, false);
            FlexTable.FlexCellFormatter frmt = (FlexTable.FlexCellFormatter)table.getCellFormatter();
            frmt.setColSpan(row + 1, 1, 4);
            table.setWidget(row + 1, 1, (Widget)src);
            this.setRowStyle(row + 1, table, style, true);
        }

        private void setRowStyle(int row, FlexTable table, String style, boolean isPanelRow) {
            table.getCellFormatter().setStyleName(row, 0, style);
            table.getCellFormatter().setStyleName(row, 1, style);
            if (!isPanelRow) {
                table.getCellFormatter().setStyleName(row, 2, style);
                table.getCellFormatter().setStyleName(row, 3, style);
                table.getCellFormatter().setStyleName(row, 4, style);
            }
        }
    }
}

