/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.clouds.client.widget;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.api.web.gwt.client.Utils;
import org.sonar.api.web.gwt.client.webservices.Measure;
import org.sonar.api.web.gwt.client.webservices.Resource;
import org.sonar.api.web.gwt.client.webservices.WSMetrics;
import org.sonar.api.web.gwt.client.widgets.LoadingLabel;
import org.sonar.plugins.core.clouds.client.Calculator;
import org.sonar.plugins.core.clouds.client.model.CloudElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassCloudsWidget
extends Composite {
    private Panel main;
    private WSMetrics.Metric sizeMetric;
    private List<Resource> resources;
    private float minSizePercent = 60.0f;
    private float maxSizePercent = 240.0f;
    private Calculator sizeCalculator = new Calculator(Float.valueOf(this.minSizePercent), Float.valueOf(this.maxSizePercent));
    private Calculator colorCalculator = new Calculator(Float.valueOf(0.0f), Float.valueOf(100.0f));

    public ClassCloudsWidget(List<Resource> resources, WSMetrics.Metric sizeMetric) {
        this.sizeMetric = sizeMetric;
        this.main = new FlowPanel();
        this.resources = resources;
        this.initWidget((Widget)this.main);
    }

    public WSMetrics.Metric getSizeMetric() {
        return this.sizeMetric;
    }

    public void generateCloud(WSMetrics.Metric colorMetric) {
        this.main.clear();
        LoadingLabel loading = new LoadingLabel();
        this.main.add((Widget)loading);
        if (colorMetric.equals((Object)colorMetric)) {
            List<CloudElement> cloudElements = this.getCloudElements(this.resources, colorMetric);
            this.createClouds(cloudElements, colorMetric);
        }
        this.main.remove((Widget)loading);
    }

    private List<CloudElement> getCloudElements(List<Resource> resources, WSMetrics.Metric colorMetric) {
        ArrayList<CloudElement> tagList = new ArrayList<CloudElement>();
        for (Resource resource : resources) {
            Measure sizeMeasure = this.getMeasure(resource, this.sizeMetric);
            Measure colorMeasure = this.getMeasure(resource, colorMetric);
            if (sizeMeasure == null || colorMeasure == null) continue;
            Integer size = this.getMeasureValue(sizeMeasure.getValue());
            float color = colorMeasure.getValue().floatValue();
            tagList.add(new CloudElement(resource, size, Float.valueOf(color)));
            this.sizeCalculator.updateMaxAndMin(Float.valueOf(size.toString()));
        }
        Collections.sort(tagList);
        return tagList;
    }

    private Integer getMeasureValue(Double value) {
        Float floatValue = Float.valueOf(value.floatValue() * 100.0f);
        return floatValue.intValue();
    }

    private Measure getMeasure(Resource project, WSMetrics.Metric metricToFind) {
        return project.getMeasure(metricToFind);
    }

    private void createClouds(List<CloudElement> cloudElements, WSMetrics.Metric colorMetric) {
        for (CloudElement tag : cloudElements) {
            HTML className = new HTML("<span style=\"font-size:" + Integer.toString(this.sizeCalculator.getFontSizePercent(tag.getFontSize())) + "%; color:" + this.colorCalculator.getFontColor(tag.getFontColor().floatValue()) + "\" >" + tag.getResource().getName() + "</span>\n");
            className.setStyleName("inline");
            Hyperlink link = this.createLink(tag, colorMetric);
            link.setHTML(className.getHTML());
            this.main.add((Widget)link);
        }
    }

    private Hyperlink createLink(CloudElement tag, final WSMetrics.Metric colorMetric) {
        Hyperlink link = new Hyperlink();
        link.setStyleName("tag inline");
        String tooltip = this.getTooltip(tag.getResource(), colorMetric);
        link.getElement().setAttribute("title", tooltip);
        link.getElement().setAttribute("rel", tooltip);
        String sizeCss = Float.toString(this.maxSizePercent / 100.0f) + "em";
        link.setHeight(sizeCss);
        final Resource clickResource = tag.getResource();
        link.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (clickResource.getCopy() != null) {
                    Window.Location.assign((String)(Utils.getServerUrl() + "/plugins/resource/" + clickResource.getCopy() + "?page=" + "org.sonar.plugins.core.clouds.GwtClouds"));
                } else {
                    Utils.openResourcePopup((Resource)clickResource, (String)colorMetric.getKey());
                }
            }
        });
        return link;
    }

    private String getTooltip(Resource resource, WSMetrics.Metric colorMetric) {
        Measure sizeMeasure = this.getMeasure(resource, this.sizeMetric);
        String sizeMetricName = this.sizeMetric.getName();
        String sizeMetricValue = sizeMeasure.getFormattedValue();
        Measure colorMeasure = this.getMeasure(resource, colorMetric);
        String colorMetricName = colorMetric.getName();
        String colorMetricValue = colorMeasure.getFormattedValue();
        return resource.getName(true) + ", " + sizeMetricName + " : " + sizeMetricValue + ", " + colorMetricName + " : " + colorMetricValue;
    }
}

