/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.clouds.client;

import com.google.gwt.core.client.JavaScriptException;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.api.web.gwt.client.AbstractPage;
import org.sonar.api.web.gwt.client.ResourceDictionary;
import org.sonar.api.web.gwt.client.webservices.BaseQueryCallback;
import org.sonar.api.web.gwt.client.webservices.MetricsQuery;
import org.sonar.api.web.gwt.client.webservices.Query;
import org.sonar.api.web.gwt.client.webservices.QueryCallBack;
import org.sonar.api.web.gwt.client.webservices.Resources;
import org.sonar.api.web.gwt.client.webservices.ResourcesQuery;
import org.sonar.api.web.gwt.client.webservices.SequentialQueries;
import org.sonar.api.web.gwt.client.webservices.VoidResponse;
import org.sonar.api.web.gwt.client.webservices.WSMetrics;
import org.sonar.api.web.gwt.client.widgets.LoadingLabel;
import org.sonar.plugins.core.clouds.client.widget.ClassCloudsWidget;
import org.sonar.plugins.core.clouds.client.widget.TabWidget;

public class GwtClouds
extends AbstractPage {
    public static final String GWT_ID = "org.sonar.plugins.core.clouds.GwtClouds";
    private Panel cloudsPanel;
    private ListBox metricsListBox;
    private Label sizeAndColorLabel;
    private TabWidget sizeTabs;
    private Resources resources;
    private final List<SizeMetric> SIZE_METRICS = Arrays.asList(new SizeMetric("Quick Wins", WSMetrics.NCLOC), new SizeMetric("Top risk", WSMetrics.FUNCTION_COMPLEXITY));
    private final List<WSMetrics.Metric> COLOR_METRICS = Arrays.asList(WSMetrics.COVERAGE, WSMetrics.VIOLATIONS_DENSITY);

    public void onModuleLoad() {
        this.cloudsPanel = new FlowPanel();
        this.displayView((Widget)this.cloudsPanel);
        this.loadClouds();
    }

    protected void loadClouds() {
        String projectKey = ResourceDictionary.getResourceKey();
        ArrayList<WSMetrics.Metric> metricsToGet = new ArrayList<WSMetrics.Metric>();
        for (SizeMetric size : this.SIZE_METRICS) {
            metricsToGet.add(size.getSizeMetric());
        }
        for (WSMetrics.Metric color : this.COLOR_METRICS) {
            metricsToGet.add(color);
        }
        if (projectKey != null) {
            this.cloudsPanel.add((Widget)new LoadingLabel());
            ResourcesQuery resourcesQuery = ResourcesQuery.get((String)projectKey).setDepth(Integer.valueOf(-1)).setScopes("FIL").setMetrics(metricsToGet);
            BaseQueryCallback<Resources> resourcesCb = new BaseQueryCallback<Resources>(){

                public void onResponse(Resources response, JavaScriptObject jsonRawResponse) {
                    GwtClouds.this.resources = response;
                }
            };
            MetricsQuery metrics = MetricsQuery.get().setUserManaged(Boolean.valueOf(false));
            BaseQueryCallback<WSMetrics.MetricsList> metricsCb = new BaseQueryCallback<WSMetrics.MetricsList>(){

                public void onResponse(WSMetrics.MetricsList response, JavaScriptObject jsonRawResponse) {
                }
            };
            metricsCb = WSMetrics.getUpdateMetricsFromServer((QueryCallBack)metricsCb);
            BaseQueryCallback<VoidResponse> updateCloudsCb = new BaseQueryCallback<VoidResponse>(){

                public void onResponse(VoidResponse response, JavaScriptObject jsonRawResponse) {
                    GwtClouds.this.updateClouds(GwtClouds.this.resources);
                }
            };
            SequentialQueries.get().add((Query)resourcesQuery, (QueryCallBack)resourcesCb).add((Query)metrics, (QueryCallBack)metricsCb).execute((QueryCallBack)updateCloudsCb);
        }
    }

    private void updateClouds(Resources resources) {
        this.cloudsPanel.clear();
        Panel metricSelectPanel = this.getMetricColorSelectBox(resources);
        this.sizeTabs = new TabWidget(new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                GwtClouds.this.renderClassCloudsForCurrentMetric();
            }
        });
        for (SizeMetric size : this.SIZE_METRICS) {
            ClassCloudsWidget classCloudsTab = new ClassCloudsWidget(resources.getResources(), size.getSizeMetric());
            this.sizeTabs.addTab((Widget)classCloudsTab, size.getTabName(), size.getTabNameId());
        }
        this.cloudsPanel.add((Widget)metricSelectPanel);
        this.cloudsPanel.add((Widget)this.sizeTabs);
    }

    private Panel getMetricColorSelectBox(Resources resources) {
        HTMLPanel metricSelectPanel = new HTMLPanel("<div id='select_metric' class='metricSelectBox small'> </div>");
        this.sizeAndColorLabel = new InlineLabel();
        this.sizeAndColorLabel.setStyleName("labelText gray");
        metricSelectPanel.add((Widget)this.sizeAndColorLabel, "select_metric");
        this.metricsListBox = new ListBox(false);
        for (WSMetrics.Metric color : this.COLOR_METRICS) {
            if (!resources.onceContainsMeasure(color)) continue;
            this.metricsListBox.addItem(color.getName(), color.getKey());
        }
        metricSelectPanel.add((Widget)this.metricsListBox, "select_metric");
        this.metricsListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                GwtClouds.this.renderClassCloudsForCurrentMetric();
            }
        });
        return metricSelectPanel;
    }

    private void generateSizeAndColorLabel() {
        this.sizeAndColorLabel.setText("Size : " + this.getCurrentSizeMetric().getName() + ", color : ");
    }

    private void renderClassCloudsForCurrentMetric() {
        Widget widget = this.sizeTabs.getSelectedWidget();
        if (widget instanceof ClassCloudsWidget) {
            WSMetrics.Metric current = this.getCurrentColorMetric();
            ClassCloudsWidget classCloudsWidget = (ClassCloudsWidget)widget;
            classCloudsWidget.generateCloud(current);
            this.generateSizeAndColorLabel();
        }
    }

    private WSMetrics.Metric getCurrentColorMetric() {
        String metricKey = this.metricsListBox.getValue(this.metricsListBox.getSelectedIndex());
        for (WSMetrics.Metric color : this.COLOR_METRICS) {
            if (!color.getKey().equals(metricKey)) continue;
            return color;
        }
        throw new JavaScriptException((Object)("Unable to find metric " + metricKey));
    }

    private WSMetrics.Metric getCurrentSizeMetric() {
        String selectedTabId = this.sizeTabs.getSelectedTabId();
        for (SizeMetric size : this.SIZE_METRICS) {
            if (!size.getTabNameId().equals(selectedTabId)) continue;
            return size.sizeMetric;
        }
        throw new JavaScriptException((Object)("Unable to find metric for tab " + selectedTabId));
    }

    private class SizeMetric {
        private String tabName;
        private WSMetrics.Metric sizeMetric;

        public SizeMetric(String tabName, WSMetrics.Metric sizeMetric) {
            this.tabName = tabName;
            this.sizeMetric = sizeMetric;
        }

        public String getTabName() {
            return this.tabName;
        }

        public WSMetrics.Metric getSizeMetric() {
            return this.sizeMetric;
        }

        public String getTabNameId() {
            return this.tabName.toLowerCase().replace(' ', '_');
        }
    }
}

