/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.clouds.client;

import org.sonar.plugins.core.clouds.client.model.Color;

public class Calculator {
    private Float minValue;
    private Float maxValue;
    private Float minPercent;
    private Float maxPercent;

    public Calculator(Float minPercent, Float maxPercent) {
        this.minPercent = minPercent;
        this.maxPercent = maxPercent;
    }

    public void updateMaxAndMin(Float value) {
        this.updateMaxValue(value);
        this.updateMinValue(value);
    }

    public Integer getFontSizePercent(Integer value) {
        float divisor = this.getMaxValue().floatValue() - this.getMinValue().floatValue();
        float size = this.getMinPercent().floatValue();
        if (divisor != 0.0f) {
            float multiplier = (this.getMaxPercent().floatValue() - this.getMinPercent().floatValue()) / divisor;
            size = this.getMinPercent().floatValue() + (this.getMaxValue().floatValue() - (this.getMaxValue().floatValue() - ((float)value.intValue() - this.getMinValue().floatValue()))) * multiplier;
        }
        return Float.valueOf(size).intValue();
    }

    public String getFontColor(float value) {
        Color color;
        float valuePercent;
        float interval = (this.getMaxPercent().floatValue() - this.getMinPercent().floatValue()) / 2.0f;
        float mean = (this.getMinPercent().floatValue() + this.getMaxPercent().floatValue()) / 2.0f;
        Color minColor = new Color(0.7490196f, 0.0f, 0.08235294f);
        Color meanColor = new Color(0.3019608f, 0.019607844f, 0.69411767f);
        Color maxColor = new Color(0.09019608f, 0.3764706f, 0.7490196f);
        if (value > mean) {
            valuePercent = (value - mean) / interval * 100.0f;
            color = this.mixColorWith(maxColor, meanColor, valuePercent);
        } else {
            valuePercent = (mean - value) / interval * 100.0f;
            color = this.mixColorWith(minColor, meanColor, valuePercent);
        }
        int r = Float.valueOf(color.getRed() * 255.0f).intValue();
        int g = Float.valueOf(color.getGreen() * 255.0f).intValue();
        int b = Float.valueOf(color.getBlue() * 255.0f).intValue();
        return "rgb(" + r + "," + g + "," + b + ")";
    }

    private Color mixColorWith(Color currentColor, Color mask, float value) {
        float opacity = value / 100.0f;
        float r = currentColor.getRed() * opacity + mask.getRed() * (1.0f - opacity);
        float g = currentColor.getGreen() * opacity + mask.getGreen() * (1.0f - opacity);
        float b = currentColor.getBlue() * opacity + mask.getBlue() * (1.0f - opacity);
        return new Color(r, g, b);
    }

    private void updateMaxValue(Float value) {
        if (this.maxValue == null) {
            this.maxValue = value;
        } else if (value.floatValue() > this.maxValue.floatValue()) {
            this.maxValue = value;
        }
    }

    private void updateMinValue(Float value) {
        if (this.minValue == null) {
            this.minValue = value;
        } else if (value.floatValue() < this.minValue.floatValue()) {
            this.minValue = value;
        }
    }

    public Float getMinValue() {
        return this.minValue;
    }

    public Float getMaxValue() {
        return this.maxValue;
    }

    public Float getMinPercent() {
        return this.minPercent;
    }

    public Float getMaxPercent() {
        return this.maxPercent;
    }
}

