/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.charts;

import java.awt.Font;
import java.awt.Paint;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.Values2D;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.sonar.api.charts.AbstractChart;
import org.sonar.api.charts.ChartParameters;

public class DistributionBarChart
extends AbstractChart {
    public static final String PARAM_VALUES = "v";
    public static final String PARAM_COLORS = "c";
    public static final String PARAM_Y_SUFFIX = "ysuf";
    public static final String PARAM_X_SUFFIX = "xsuf";
    public static final String PARAM_FONT_SIZE = "fs";

    public String getKey() {
        return "distbar";
    }

    public Plot getPlot(ChartParameters params) {
        CategoryPlot plot = this.generateJFreeChart(params);
        plot.setOutlinePaint((Paint)OUTLINE_COLOR);
        plot.setDomainGridlinePaint((Paint)GRID_COLOR);
        plot.setRangeGridlinePaint((Paint)GRID_COLOR);
        return plot;
    }

    private CategoryPlot generateJFreeChart(ChartParameters params) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        CategoryPlot plot = new CategoryPlot();
        Font font = this.getFont(params.getValue(PARAM_FONT_SIZE));
        this.configureDomainAxis(plot, font);
        this.configureRangeAxis(plot, params.getValue(PARAM_Y_SUFFIX, "", true), font);
        this.configureRenderer(plot);
        DistributionBarChart.configureValues(dataset, params.getValues(PARAM_VALUES, "|", true), params.getValue(PARAM_X_SUFFIX, "", true));
        this.configureColors((Values2D)dataset, plot, params.getValues(PARAM_COLORS, ","));
        plot.setDataset((CategoryDataset)dataset);
        return plot;
    }

    static void configureValues(DefaultCategoryDataset dataset, String[] series, String xSuffix) {
        for (int index = 0; index < series.length; ++index) {
            String[] pairs = StringUtils.split((String)series[index], (String)";");
            if (pairs.length == 0) {
                dataset.addValue((Number)0.0, (Comparable)Integer.valueOf(index), (Comparable)((Object)"0"));
                continue;
            }
            for (String pair : pairs) {
                String[] keyValue = StringUtils.split((String)pair, (String)"=");
                double val = Double.parseDouble(keyValue[1]);
                dataset.addValue((Number)val, (Comparable)Integer.valueOf(index), (Comparable)((Object)(keyValue[0] + xSuffix)));
            }
        }
    }

    private void configureRenderer(CategoryPlot plot) {
        BarRenderer renderer = new BarRenderer();
        renderer.setDrawBarOutline(true);
        renderer.setSeriesItemLabelsVisible(0, true);
        renderer.setItemMargin(0.0);
        plot.setRenderer((CategoryItemRenderer)renderer);
    }

    private void configureDomainAxis(CategoryPlot plot, Font font) {
        CategoryAxis categoryAxis = new CategoryAxis();
        categoryAxis.setTickMarksVisible(true);
        categoryAxis.setTickLabelFont(font);
        categoryAxis.setTickLabelPaint((Paint)OUTLINE_COLOR);
        plot.setDomainAxis(categoryAxis);
        plot.setDomainGridlinesVisible(false);
    }

    private Font getFont(String fontSize) {
        int size = 13;
        if (!StringUtils.isBlank((String)fontSize)) {
            size = Integer.parseInt(fontSize);
        }
        return new Font("SansSerif", 0, size);
    }

    private void configureRangeAxis(CategoryPlot plot, String valueLabelSuffix, Font font) {
        NumberAxis numberAxis = new NumberAxis();
        numberAxis.setUpperMargin(0.3);
        numberAxis.setTickLabelFont(font);
        numberAxis.setTickLabelPaint((Paint)OUTLINE_COLOR);
        String suffix = "";
        if (valueLabelSuffix != null && !"".equals(valueLabelSuffix)) {
            suffix = "'" + valueLabelSuffix + "'";
        }
        numberAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat("0" + suffix));
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setRangeAxis((ValueAxis)numberAxis);
    }
}

