/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.charts;

import java.text.NumberFormat;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.Values2D;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.sonar.api.charts.AbstractChart;
import org.sonar.api.charts.ChartParameters;

public class DistributionAreaChart
extends AbstractChart {
    private static final String PARAM_COLORS = "c";

    public String getKey() {
        return "distarea";
    }

    protected Plot getPlot(ChartParameters params) {
        DefaultCategoryDataset dataset = this.createDataset(params);
        CategoryAxis domainAxis = new CategoryAxis();
        domainAxis.setCategoryMargin(0.0);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        NumberAxis rangeAxis = new NumberAxis();
        rangeAxis.setNumberFormatOverride(NumberFormat.getIntegerInstance(params.getLocale()));
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        AreaRenderer renderer = new AreaRenderer();
        CategoryPlot plot = new CategoryPlot((CategoryDataset)dataset, domainAxis, (ValueAxis)rangeAxis, (CategoryItemRenderer)renderer);
        plot.setForegroundAlpha(0.5f);
        plot.setDomainGridlinesVisible(true);
        this.configureColors((Values2D)dataset, plot, params.getValues(PARAM_COLORS, ","));
        return plot;
    }

    private DefaultCategoryDataset createDataset(ChartParameters params) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        String[] series = params.getValues("v", "|", true);
        for (int index = 0; index < series.length; ++index) {
            String[] pairs = StringUtils.split((String)series[index], (String)";");
            if (pairs.length == 0) {
                dataset.addValue((Number)0.0, (Comparable)Integer.valueOf(index), (Comparable)((Object)"0"));
                continue;
            }
            for (String pair : pairs) {
                String[] keyValue = StringUtils.split((String)pair, (String)"=");
                double val = Double.parseDouble(keyValue[1]);
                dataset.addValue((Number)val, (Comparable)Integer.valueOf(index), (Comparable)((Object)keyValue[0]));
            }
        }
        return dataset;
    }
}

