/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.batch;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;
import org.sonar.api.batch.Initializer;
import org.sonar.api.batch.SupportedEnvironment;
import org.sonar.api.batch.maven.MavenUtils;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.Logs;

@SupportedEnvironment(value={"maven"})
public class MavenInitializer
extends Initializer {
    public void execute(Project project) {
        String version;
        MavenProject pom = project.getPom();
        Configuration conf = project.getConfiguration();
        if (StringUtils.isBlank((String)conf.getString("sonar.java.source"))) {
            version = MavenUtils.getJavaSourceVersion((MavenProject)pom);
            conf.setProperty("sonar.java.source", (Object)version);
            Logs.INFO.info("Java source version: {}", (Object)version);
        }
        if (StringUtils.isBlank((String)conf.getString("sonar.java.target"))) {
            version = MavenUtils.getJavaVersion((MavenProject)pom);
            conf.setProperty("sonar.java.target", (Object)version);
            Logs.INFO.info("Java target version: {}", (Object)version);
        }
        if (StringUtils.isBlank((String)conf.getString("sonar.sourceEncoding"))) {
            String encoding = MavenUtils.getSourceEncoding((MavenProject)pom);
            conf.setProperty("sonar.sourceEncoding", (Object)encoding);
            Logs.INFO.info("Source encoding: {}", (Object)encoding);
        }
    }
}

