/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea14;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNProperties13;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;

public abstract class SVNProperties14
extends SVNVersionedProperties {
    private SVNAdminArea14 myAdminArea;
    private String myEntryName;

    public SVNProperties14(SVNProperties props, SVNAdminArea14 adminArea, String entryName) {
        super(props);
        this.myAdminArea = adminArea;
        this.myEntryName = entryName;
    }

    public boolean containsProperty(String name) throws SVNException {
        SVNProperties propsMap = this.getProperties();
        if (propsMap != null && propsMap.containsName(name)) {
            return true;
        }
        SVNEntry entry = this.myAdminArea.getEntry(this.myEntryName, true);
        if (entry == null) {
            return false;
        }
        String[] cachableProps = entry.getCachableProperties();
        if (cachableProps != null && this.getIndex(cachableProps, name) >= 0) {
            String[] presentProps = entry.getPresentProperties();
            return presentProps != null && this.getIndex(presentProps, name) >= 0;
        }
        if (!this.isEmpty()) {
            SVNProperties props = this.loadProperties();
            return props.containsName(name);
        }
        return false;
    }

    public SVNPropertyValue getPropertyValue(String name) throws SVNException {
        String[] cachableProps;
        if (this.getProperties() != null && this.getProperties().containsName(name)) {
            return this.getProperties().getSVNPropertyValue(name);
        }
        SVNEntry entry = this.myAdminArea.getEntry(this.myEntryName, true);
        if (entry != null && (cachableProps = entry.getCachableProperties()) != null && this.getIndex(cachableProps, name) >= 0) {
            String[] presentProps = entry.getPresentProperties();
            if (presentProps == null || this.getIndex(presentProps, name) < 0) {
                return null;
            }
            if (SVNProperty.isBooleanProperty(name)) {
                return SVNProperty.getValueOfBooleanProperty(name);
            }
        }
        SVNProperties props = this.loadProperties();
        if (!this.isEmpty()) {
            return props.getSVNPropertyValue(name);
        }
        return null;
    }

    private int getIndex(String[] array, String element) {
        if (array == null || element == null) {
            return -1;
        }
        int i = 0;
        while (i < array.length) {
            if (element.equals(array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected SVNVersionedProperties wrap(SVNProperties properties) {
        return new SVNProperties13(properties);
    }
}

