/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea14;

public class SVNAdminArea15
extends SVNAdminArea14 {
    public static final int WC_FORMAT = 9;
    protected static final String ATTRIBUTE_KEEP_LOCAL = "keep-local";
    private static final Set INAPPLICABLE_PROPERTIES = new SVNHashSet();

    static {
        INAPPLICABLE_PROPERTIES.add("svn:entry:file-external-path");
        INAPPLICABLE_PROPERTIES.add("svn:entry:file-external-revision");
        INAPPLICABLE_PROPERTIES.add("svn:entry:file-external-peg-revision");
        INAPPLICABLE_PROPERTIES.add("svn:entry:tree-conflicts");
    }

    public SVNAdminArea15(File dir) {
        super(dir);
    }

    public int getFormatVersion() {
        return 9;
    }

    protected boolean readExtraOptions(BufferedReader reader, Map entryAttrs) throws SVNException, IOException {
        String line = reader.readLine();
        if (this.isEntryFinished(line)) {
            return true;
        }
        String changelist = this.parseString(line);
        if (changelist != null) {
            entryAttrs.put("svn:entry:changelist", changelist);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return true;
        }
        boolean keepLocal = this.parseBoolean(line, ATTRIBUTE_KEEP_LOCAL);
        if (keepLocal) {
            entryAttrs.put("svn:entry:keep-local", SVNProperty.toString(keepLocal));
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return true;
        }
        String workingSize = this.parseString(line);
        if (workingSize != null) {
            entryAttrs.put("svn:entry:working-size", workingSize);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return true;
        }
        String depthStr = this.parseValue(line);
        if (depthStr == null) {
            entryAttrs.put("svn:entry:depth", SVNDepth.INFINITY.getName());
        } else {
            entryAttrs.put("svn:entry:depth", depthStr);
        }
        return false;
    }

    protected int writeExtraOptions(Writer writer, String entryName, Map entryAttrs, int emptyFields) throws SVNException, IOException {
        emptyFields = super.writeExtraOptions(writer, entryName, entryAttrs, emptyFields);
        String changelist = (String)entryAttrs.get("svn:entry:changelist");
        emptyFields = this.writeString(writer, changelist, emptyFields) ? 0 : ++emptyFields;
        String keepLocalAttr = (String)entryAttrs.get("svn:entry:keep-local");
        if (SVNProperty.booleanValue(keepLocalAttr)) {
            this.writeValue(writer, ATTRIBUTE_KEEP_LOCAL, emptyFields);
            emptyFields = 0;
        } else {
            ++emptyFields;
        }
        String workingSize = (String)entryAttrs.get("svn:entry:working-size");
        String string = workingSize = "-1".equals(workingSize) ? null : workingSize;
        emptyFields = this.writeString(writer, workingSize, emptyFields) ? 0 : ++emptyFields;
        boolean isThisDir = this.getThisDirName().equals(entryName);
        boolean isSubDir = !isThisDir && "dir".equals(entryAttrs.get("svn:entry:kind"));
        String depthStr = (String)entryAttrs.get("svn:entry:depth");
        SVNDepth depth = SVNDepth.fromString(depthStr);
        emptyFields = isSubDir && depth != SVNDepth.EXCLUDE || depth == SVNDepth.INFINITY ? ++emptyFields : (this.writeValue(writer, depthStr, emptyFields) ? 0 : ++emptyFields);
        return emptyFields;
    }

    protected SVNAdminArea createAdminAreaForDir(File dir) {
        return new SVNAdminArea15(dir);
    }

    protected boolean isEntryPropertyApplicable(String propName) {
        return propName != null && !INAPPLICABLE_PROPERTIES.contains(propName);
    }
}

