/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNConnectionOptions;
import org.tmatesoft.svn.core.internal.wc.SVNCompositeConfigFile;

public class DefaultSVNConnectionOptions
implements ISVNConnectionOptions {
    private static final String[] DEFAULT_PASSWORD_STORE_TYPES = new String[]{"windows-cryptoapi", "keychain"};
    private final SVNCompositeConfigFile myServersFile;
    private final SVNCompositeConfigFile myConfigFile;

    public DefaultSVNConnectionOptions(SVNCompositeConfigFile serversFile, SVNCompositeConfigFile configFile) {
        this.myServersFile = serversFile;
        this.myConfigFile = configFile;
    }

    private SVNCompositeConfigFile getServersFile() {
        return this.myServersFile;
    }

    private SVNCompositeConfigFile getConfigFile() {
        return this.myConfigFile;
    }

    public Collection getAuthTypes(SVNURL url) {
        ArrayList<String> schemes = new ArrayList<String>();
        String host = url.getHost();
        Map hostProperties = this.getHostProperties(host);
        String authTypes = (String)hostProperties.get("http-auth-types");
        if (authTypes == null || "".equals(authTypes.trim())) {
            return schemes;
        }
        StringTokenizer tokens = new StringTokenizer(authTypes, ";");
        while (tokens.hasMoreTokens()) {
            String scheme = tokens.nextToken();
            if (schemes.contains(scheme)) continue;
            schemes.add(scheme);
        }
        return schemes;
    }

    private String getAuthStorageEnabledOption(SVNURL url) {
        String host = url != null ? url.getHost() : null;
        Map properties = this.getHostProperties(host);
        return (String)properties.get("store-auth-creds");
    }

    public boolean hasAuthStorageEnabledOption(SVNURL url) {
        return this.getAuthStorageEnabledOption(url) != null;
    }

    public boolean isAuthStorageEnabled(SVNURL url) {
        String storeAuthCreds = this.getAuthStorageEnabledOption(url);
        if (storeAuthCreds == null) {
            return false;
        }
        return "yes".equalsIgnoreCase(storeAuthCreds) || "on".equalsIgnoreCase(storeAuthCreds) || "true".equalsIgnoreCase(storeAuthCreds);
    }

    public String[] getPasswordStorageTypes() {
        String storeTypesOption = this.getConfigFile().getPropertyValue("auth", "password-stores");
        if (storeTypesOption == null) {
            return DEFAULT_PASSWORD_STORE_TYPES;
        }
        ArrayList<String> storeTypes = new ArrayList<String>();
        StringTokenizer types = new StringTokenizer(storeTypesOption, " ,");
        while (types.hasMoreTokens()) {
            String type = types.nextToken();
            String string = type = type == null ? null : type.trim();
            if (type == null || "".equals(type)) continue;
            storeTypes.add(type);
        }
        return storeTypes.toArray(new String[storeTypes.size()]);
    }

    public boolean isStorePasswords(SVNURL url) {
        String host;
        Map properties;
        String storePasswords;
        boolean store = true;
        String value = this.getConfigFile().getPropertyValue("auth", "store-passwords");
        if (value != null) {
            store = "yes".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
        }
        if ((storePasswords = (String)(properties = this.getHostProperties(host = url != null ? url.getHost() : null)).get("store-passwords")) == null) {
            return store;
        }
        return "yes".equalsIgnoreCase(storePasswords) || "on".equalsIgnoreCase(storePasswords) || "true".equalsIgnoreCase(storePasswords);
    }

    private String getStorePlainTextPasswordOption(SVNAuthentication auth) {
        SVNURL url = auth.getURL();
        String host = url != null ? url.getHost() : null;
        Map properties = this.getHostProperties(host);
        return (String)properties.get("store-plaintext-passwords");
    }

    public boolean isStorePlainTextPasswords(String realm, SVNAuthentication auth) throws SVNException {
        String storePlainTextPasswords = this.getStorePlainTextPasswordOption(auth);
        if (storePlainTextPasswords == null) {
            return false;
        }
        return "yes".equalsIgnoreCase(storePlainTextPasswords) || "on".equalsIgnoreCase(storePlainTextPasswords) || "true".equalsIgnoreCase(storePlainTextPasswords);
    }

    public boolean isStoreSSLClientCertificatePassphrases(SVNURL url) {
        String host = url != null ? url.getHost() : null;
        Map properties = this.getHostProperties(host);
        String storeCertPassphrases = (String)properties.get("store-ssl-client-cert-pp");
        if (storeCertPassphrases == null) {
            return true;
        }
        return "yes".equalsIgnoreCase(storeCertPassphrases) || "on".equalsIgnoreCase(storeCertPassphrases) || "true".equalsIgnoreCase(storeCertPassphrases);
    }

    private String getStorePlainTextPassphraseOption(SVNAuthentication auth) {
        SVNURL url = auth.getURL();
        String host = url != null ? url.getHost() : null;
        Map properties = this.getHostProperties(host);
        return (String)properties.get("store-ssl-client-cert-pp-plaintext");
    }

    public boolean isStorePlainTextPassphrases(String realm, SVNAuthentication auth) throws SVNException {
        String storePlainTextPassphrases = this.getStorePlainTextPassphraseOption(auth);
        if (storePlainTextPassphrases == null) {
            return false;
        }
        return "yes".equalsIgnoreCase(storePlainTextPassphrases) || "on".equalsIgnoreCase(storePlainTextPassphrases) || "true".equalsIgnoreCase(storePlainTextPassphrases);
    }

    public String getUserName(SVNURL url) {
        String host = url != null ? url.getHost() : null;
        Map properties = this.getHostProperties(host);
        String userName = (String)properties.get("username");
        return userName;
    }

    private String getDefaultSSHCommandLine() {
        Map tunnels = this.getConfigFile().getProperties("tunnels");
        if (tunnels == null || !tunnels.containsKey("ssh")) {
            return null;
        }
        return (String)tunnels.get("ssh");
    }

    private String getDefaultSSHOptionValue(String optionName, String systemProperty, String fallbackSystemProperty) {
        String value;
        String sshCommandLine;
        if (optionName != null && (sshCommandLine = this.getDefaultSSHCommandLine()) != null && (value = DefaultSVNConnectionOptions.getOptionValue(sshCommandLine, optionName)) != null) {
            return value;
        }
        return System.getProperty(systemProperty, System.getProperty(fallbackSystemProperty));
    }

    public int getDefaultSSHPortNumber() {
        String sshCommandLine = this.getDefaultSSHCommandLine();
        if (sshCommandLine == null) {
            return -1;
        }
        String portOption = sshCommandLine.toLowerCase().trim().startsWith("plink") ? "-p" : "-P";
        String port = this.getDefaultSSHOptionValue(portOption, "svnkit.ssh2.port", "javasvn.ssh2.port");
        if (port != null) {
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public String getDefaultSSHUserName() {
        String userName = this.getDefaultSSHOptionValue("-l", "svnkit.ssh2.username", "javasvn.ssh2.username");
        if (userName == null) {
            userName = System.getProperty("user.name");
        }
        return userName;
    }

    public String getDefaultSSHPassword() {
        return this.getDefaultSSHOptionValue("-pw", "svnkit.ssh2.password", "javasvn.ssh2.password");
    }

    public String getDefaultSSHKeyFile() {
        return this.getDefaultSSHOptionValue("-i", "svnkit.ssh2.key", "javasvn.ssh2.key");
    }

    public String getDefaultSSHPassphrase() {
        return this.getDefaultSSHOptionValue(null, "svnkit.ssh2.passphrase", "javasvn.ssh2.passphrase");
    }

    public String getSSLClientCertFile(SVNURL url) {
        Map properties = this.getHostProperties(url.getHost());
        return (String)properties.get("ssl-client-cert-file");
    }

    public String getSSLClientCertPassword(SVNURL url) {
        Map properties = this.getHostProperties(url.getHost());
        return (String)properties.get("ssl-client-cert-password");
    }

    public boolean trustDefaultSSLCertificateAuthority(SVNURL url) {
        String host = url.getHost();
        Map properties = this.getHostProperties(host);
        return !"no".equalsIgnoreCase((String)properties.get("ssl-trust-default-ca"));
    }

    public File[] getSSLAuthorityFiles(SVNURL url) {
        String host = url.getHost();
        Map properties = this.getHostProperties(host);
        String sslAuthorityFilePaths = (String)properties.get("ssl-authority-files");
        ArrayList<File> trustStorages = new ArrayList<File>();
        if (sslAuthorityFilePaths != null) {
            StringTokenizer files = new StringTokenizer(sslAuthorityFilePaths, ";");
            while (files.hasMoreTokens()) {
                String fileName = files.nextToken();
                String string = fileName = fileName == null ? null : fileName.trim();
                if (fileName == null || "".equals(fileName)) continue;
                trustStorages.add(new File(fileName));
            }
        }
        return trustStorages.toArray(new File[trustStorages.size()]);
    }

    public String getProxyHost(SVNURL url) {
        return this.getProxyOption(url, "http-proxy-host", "http.proxyHost");
    }

    public String getProxyPort(SVNURL url) {
        return this.getProxyOption(url, "http-proxy-port", "http.proxyPort");
    }

    public String getProxyUserName(SVNURL url) {
        return this.getProxyOption(url, "http-proxy-username", null);
    }

    public String getProxyPassword(SVNURL url) {
        return this.getProxyOption(url, "http-proxy-password", null);
    }

    private String getProxyOption(SVNURL url, String optionName, String systemProperty) {
        if (url == null || optionName == null) {
            return null;
        }
        String host = url.getHost();
        Map properties = this.getHostProperties(host);
        String value = (String)properties.get(optionName);
        if ((value == null || "".equals(value.trim())) && systemProperty != null) {
            value = System.getProperty(systemProperty);
        }
        if (value == null || "".equals(value.trim())) {
            return null;
        }
        if (DefaultSVNConnectionOptions.hostExceptedFromProxy(host, properties)) {
            return null;
        }
        return value;
    }

    private static boolean hostExceptedFromProxy(String host, Map properties) {
        String proxyExceptions = (String)properties.get("http-proxy-exceptions");
        String proxyExceptionsSeparator = ",";
        if (proxyExceptions == null) {
            proxyExceptions = System.getProperty("http.nonProxyHosts");
            proxyExceptionsSeparator = "|";
        }
        if (proxyExceptions != null) {
            StringTokenizer exceptions = new StringTokenizer(proxyExceptions, proxyExceptionsSeparator);
            while (exceptions.hasMoreTokens()) {
                String exception = exceptions.nextToken().trim();
                if (!DefaultSVNOptions.matches(exception, host)) continue;
                return true;
            }
        }
        return false;
    }

    public int getReadTimeout(SVNURL url) {
        String protocol = url.getProtocol();
        if ("http".equals(protocol) || "https".equals(protocol)) {
            String host = url.getHost();
            Map properties = this.getHostProperties(host);
            String timeout = (String)properties.get("http-timeout");
            if (timeout != null) {
                try {
                    return Integer.parseInt(timeout) * 1000;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 3600000;
        }
        return 0;
    }

    public int getConnectTimeout(SVNURL url) {
        String protocol = url.getProtocol();
        if ("http".equals(protocol) || "https".equals(protocol)) {
            return 60000;
        }
        return 0;
    }

    private Map getHostProperties(String host) {
        Map globalProps = this.getServersFile().getProperties("global");
        String groupName = DefaultSVNConnectionOptions.getGroupName(this.getServersFile().getProperties("groups"), host);
        if (groupName != null) {
            Map hostProps = this.getServersFile().getProperties(groupName);
            globalProps.putAll(hostProps);
        }
        return globalProps;
    }

    private static String getGroupName(Map groups, String host) {
        for (String name : groups.keySet()) {
            String pattern = (String)groups.get(name);
            StringTokenizer tokens = new StringTokenizer(pattern, ",");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (!DefaultSVNOptions.matches(token, host)) continue;
                return name;
            }
        }
        return null;
    }

    private static String getOptionValue(String commandLine, String optionName) {
        if (commandLine == null || optionName == null) {
            return null;
        }
        StringTokenizer options = new StringTokenizer(commandLine, " \r\n\t");
        while (options.hasMoreTokens()) {
            String option = options.nextToken().trim();
            if (optionName.equals(option) && options.hasMoreTokens()) {
                return options.nextToken();
            }
            if (!option.startsWith(optionName)) continue;
            return option.substring(optionName.length());
        }
        return null;
    }
}

