/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util.jna;

import java.io.File;
import java.lang.reflect.Method;

public class SVNOS2Util {
    private static boolean ourIsJNAEnabled;
    private static boolean ourIsOS2IO4JPresent;
    private static Class os2io4jClazz;
    private static Method setReadOnlyMethod;
    private static Method setHiddenMethod;
    private static Method moveFileMethod;

    static {
        try {
            os2io4jClazz = Class.forName("de.rbri.os2io4j.OS2IO4J");
            setReadOnlyMethod = os2io4jClazz.getMethod("setReadOnly", File.class, Boolean.TYPE);
            setHiddenMethod = os2io4jClazz.getMethod("setHidden", File.class, Boolean.TYPE);
            moveFileMethod = os2io4jClazz.getMethod("moveFile", File.class, File.class);
            ourIsOS2IO4JPresent = true;
        }
        catch (Throwable e) {
            ourIsOS2IO4JPresent = false;
        }
        String jnaEnabledProperty = System.getProperty("svnkit.useJNA", "true");
        ourIsJNAEnabled = Boolean.valueOf(jnaEnabledProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setJNAEnabled(boolean enabled) {
        Class<SVNOS2Util> clazz = SVNOS2Util.class;
        synchronized (SVNOS2Util.class) {
            ourIsJNAEnabled = enabled;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOS2IO4JPresent() {
        Class<SVNOS2Util> clazz = SVNOS2Util.class;
        synchronized (SVNOS2Util.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ourIsOS2IO4JPresent && ourIsJNAEnabled;
        }
    }

    public static boolean setWritable(File file) {
        if (file == null) {
            return false;
        }
        if (SVNOS2Util.isOS2IO4JPresent()) {
            try {
                Object[] arguments = new Object[]{file, Boolean.FALSE};
                setReadOnlyMethod.invoke(null, arguments);
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean setHidden(File file, boolean hidden) {
        if (file == null) {
            return false;
        }
        if (SVNOS2Util.isOS2IO4JPresent()) {
            try {
                Object[] arguments = new Object[]{file, hidden};
                setHiddenMethod.invoke(null, arguments);
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean moveFile(File src, File dst) {
        if (src == null || dst == null) {
            return false;
        }
        if (SVNOS2Util.isOS2IO4JPresent()) {
            try {
                Object[] arguments = new Object[]{src, dst};
                moveFileMethod.invoke(null, arguments);
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }
}

