/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util.jna;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.UnsupportedEncodingException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.jna.ISVNMacOsCFLibrary;
import org.tmatesoft.svn.core.internal.util.jna.ISVNMacOsSecurityLibrary;
import org.tmatesoft.svn.core.internal.util.jna.JNALibraryLoader;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

class SVNMacOsKeychain {
    private static final int ERR_SEC_ITEM_NOT_FOUND = -25300;

    SVNMacOsKeychain() {
    }

    static boolean isEnabled() {
        return SVNFileUtil.isOSX && JNALibraryLoader.getMacOsSecurityLibrary() != null;
    }

    public static synchronized boolean setPassword(String realm, String userName, String password, boolean nonInteractive) throws SVNException {
        ISVNMacOsSecurityLibrary library = JNALibraryLoader.getMacOsSecurityLibrary();
        if (library == null) {
            return false;
        }
        if (realm == null) {
            return false;
        }
        if (nonInteractive) {
            library.SecKeychainSetUserInteractionAllowed(false);
        }
        try {
            byte[] rawRealm = realm.getBytes("UTF-8");
            byte[] rawUserName = userName == null ? null : userName.getBytes("UTF-8");
            int rawUserNameLength = userName == null ? 0 : rawUserName.length;
            byte[] rawPassword = password.getBytes("UTF-8");
            PointerByReference itemHolder = new PointerByReference();
            int status = library.SecKeychainFindGenericPassword(null, rawRealm.length, rawRealm, rawUserNameLength, rawUserName, null, null, itemHolder);
            if (status == -25300) {
                status = library.SecKeychainAddGenericPassword(null, rawRealm.length, rawRealm, rawUserNameLength, rawUserName, rawPassword.length, rawPassword, null);
            } else {
                Pointer item = itemHolder.getValue();
                try {
                    status = library.SecKeychainItemModifyAttributesAndData(item, null, rawPassword.length, rawPassword);
                }
                finally {
                    SVNMacOsKeychain.release(item);
                }
            }
            boolean bl = status == 0;
            return bl;
        }
        catch (UnsupportedEncodingException e) {
            SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(error, e, SVNLogType.DEFAULT);
        }
        finally {
            if (nonInteractive) {
                library.SecKeychainSetUserInteractionAllowed(true);
            }
        }
        return false;
    }

    public static synchronized String getPassword(String realm, String userName, boolean nonInteractive) throws SVNException {
        ISVNMacOsSecurityLibrary library = JNALibraryLoader.getMacOsSecurityLibrary();
        if (library == null) {
            return null;
        }
        if (realm == null) {
            return null;
        }
        if (nonInteractive) {
            library.SecKeychainSetUserInteractionAllowed(false);
        }
        try {
            String password;
            block18: {
                byte[] rawRealm = realm.getBytes("UTF-8");
                byte[] rawUserName = userName == null ? null : userName.getBytes("UTF-8");
                int rawUserNameLength = userName == null ? 0 : rawUserName.length;
                IntByReference passwordLengthHolder = new IntByReference();
                PointerByReference passwordHolder = new PointerByReference();
                int status = library.SecKeychainFindGenericPassword(null, rawRealm.length, rawRealm, rawUserNameLength, rawUserName, passwordLengthHolder, passwordHolder, null);
                if (status != 0) {
                    return null;
                }
                Pointer passwordPointer = passwordHolder.getValue();
                if (passwordPointer == null) {
                    return null;
                }
                int passwordLength = passwordLengthHolder.getValue();
                byte[] rawPassword = passwordPointer.getByteArray(0L, passwordLength);
                try {
                    try {
                        password = new String(rawPassword, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
                        SVNErrorManager.error(error, e, SVNLogType.DEFAULT);
                        password = null;
                        library.SecKeychainItemFreeContent(null, passwordPointer);
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    library.SecKeychainItemFreeContent(null, passwordPointer);
                    throw throwable;
                }
                library.SecKeychainItemFreeContent(null, passwordPointer);
            }
            String string = password;
            return string;
        }
        catch (UnsupportedEncodingException e) {
            SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(error, e, SVNLogType.DEFAULT);
            return null;
        }
        finally {
            if (nonInteractive) {
                library.SecKeychainSetUserInteractionAllowed(true);
            }
        }
    }

    private static void release(Pointer pointer) {
        ISVNMacOsCFLibrary library;
        if (pointer != null && (library = JNALibraryLoader.getMacOsCFLibrary()) != null) {
            library.CFRelease(pointer);
        }
    }
}

