/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util.jna;

import com.sun.jna.Native;
import org.tmatesoft.svn.core.internal.util.jna.ISVNCLibrary;
import org.tmatesoft.svn.core.internal.util.jna.ISVNKernel32Library;
import org.tmatesoft.svn.core.internal.util.jna.ISVNMacOsCFLibrary;
import org.tmatesoft.svn.core.internal.util.jna.ISVNMacOsSecurityLibrary;
import org.tmatesoft.svn.core.internal.util.jna.ISVNSecurityLibrary;
import org.tmatesoft.svn.core.internal.util.jna.ISVNWin32Library;
import org.tmatesoft.svn.core.internal.util.jna.ISVNWinCryptLibrary;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

class JNALibraryLoader {
    private static ISVNWinCryptLibrary ourWinCryptLibrary;
    private static ISVNKernel32Library ourKenrelLibrary;
    private static ISVNSecurityLibrary ourSecurityLibrary;
    private static ISVNCLibrary ourCLibrary;
    private static ISVNWin32Library ourWin32Library;
    private static ISVNMacOsSecurityLibrary ourMacOsSecurityLibrary;
    private static ISVNMacOsCFLibrary ourMacOsCFLibrary;
    private static volatile int ourUID;
    private static volatile int ourGID;

    static {
        ourUID = -1;
        ourGID = -1;
        if (SVNFileUtil.isWindows && !SVNFileUtil.isOS2) {
            try {
                ourWinCryptLibrary = (ISVNWinCryptLibrary)Native.loadLibrary((String)"Crypt32", ISVNWinCryptLibrary.class);
                ourKenrelLibrary = (ISVNKernel32Library)Native.loadLibrary((String)"Kernel32", ISVNKernel32Library.class);
                String securityLibraryName = JNALibraryLoader.getSecurityLibraryName();
                ourSecurityLibrary = securityLibraryName != null ? (ISVNSecurityLibrary)Native.loadLibrary((String)securityLibraryName, ISVNSecurityLibrary.class) : null;
                ourWin32Library = (ISVNWin32Library)Native.loadLibrary((String)"Shell32", ISVNWin32Library.class);
            }
            catch (Throwable th) {
                ourWinCryptLibrary = null;
                ourKenrelLibrary = null;
                ourSecurityLibrary = null;
                ourWin32Library = null;
            }
        }
        if (SVNFileUtil.isOSX || SVNFileUtil.isLinux || SVNFileUtil.isBSD || SVNFileUtil.isSolaris) {
            try {
                ourCLibrary = (ISVNCLibrary)Native.loadLibrary((String)"c", ISVNCLibrary.class);
                try {
                    ourUID = ourCLibrary.getuid();
                }
                catch (Throwable th) {
                    ourUID = -1;
                }
                try {
                    ourGID = ourCLibrary.getgid();
                }
                catch (Throwable th) {
                    ourGID = -1;
                }
            }
            catch (Throwable th) {
                ourCLibrary = null;
            }
        }
        if (SVNFileUtil.isOSX) {
            try {
                ourMacOsSecurityLibrary = (ISVNMacOsSecurityLibrary)Native.loadLibrary((String)"Security", ISVNMacOsSecurityLibrary.class);
                ourMacOsCFLibrary = (ISVNMacOsCFLibrary)Native.loadLibrary((String)"CoreFoundation", ISVNMacOsCFLibrary.class);
            }
            catch (Throwable th) {
                System.out.println(th);
                ourMacOsSecurityLibrary = null;
                ourMacOsCFLibrary = null;
            }
        }
    }

    JNALibraryLoader() {
    }

    public static int getUID() {
        return ourUID;
    }

    public static int getGID() {
        return ourGID;
    }

    public static synchronized ISVNWinCryptLibrary getWinCryptLibrary() {
        return ourWinCryptLibrary;
    }

    public static synchronized ISVNWin32Library getWin32Library() {
        return ourWin32Library;
    }

    public static synchronized ISVNKernel32Library getKernelLibrary() {
        return ourKenrelLibrary;
    }

    public static synchronized ISVNSecurityLibrary getSecurityLibrary() {
        return ourSecurityLibrary;
    }

    public static synchronized ISVNCLibrary getCLibrary() {
        return ourCLibrary;
    }

    public static synchronized ISVNMacOsSecurityLibrary getMacOsSecurityLibrary() {
        return ourMacOsSecurityLibrary;
    }

    public static synchronized ISVNMacOsCFLibrary getMacOsCFLibrary() {
        return ourMacOsCFLibrary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getSecurityLibraryName() {
        ISVNKernel32Library library = JNALibraryLoader.getKernelLibrary();
        if (library == null) {
            return null;
        }
        ISVNKernel32Library.OSVERSIONINFO osInfo = null;
        ISVNKernel32Library iSVNKernel32Library = library;
        synchronized (iSVNKernel32Library) {
            try {
                osInfo = new ISVNKernel32Library.OSVERSIONINFO();
                osInfo.write();
                int rc = library.GetVersionExW(osInfo.getPointer());
                osInfo.read();
                if (rc == 0) {
                    return null;
                }
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, th);
                return null;
            }
        }
        if (osInfo.dwPlatformId.intValue() == 2) {
            return "Security";
        }
        if (osInfo.dwPlatformId.intValue() == 1) {
            return "Secur32";
        }
        return null;
    }
}

