/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.util.Collection;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class SVNURLUtil {
    public static String getRelativeURL(SVNURL parent, SVNURL child) {
        String childURLAsString;
        String parentURLAsString = parent.toString();
        String relativePath = SVNPathUtil.getPathAsChild(parentURLAsString, childURLAsString = child.toString());
        return relativePath == null ? "" : relativePath;
    }

    public static SVNURL getCommonURLAncestor(SVNURL url1, SVNURL url2) {
        if (url1 == null || url2 == null) {
            return null;
        }
        if (!url1.getProtocol().equals(url2.getProtocol()) || !url1.getHost().equals(url2.getHost()) || url1.getPort() != url2.getPort()) {
            return null;
        }
        if (url1.getUserInfo() != null ? !url1.getUserInfo().equals(url2.getUserInfo()) : url2.getUserInfo() != null) {
            return null;
        }
        String path1 = url1.getPath();
        String path2 = url2.getPath();
        String commonPath = SVNPathUtil.getCommonPathAncestor(path1, path2);
        try {
            return url1.setPath(commonPath, false);
        }
        catch (SVNException sVNException) {
            return null;
        }
    }

    public static SVNURL condenceURLs(SVNURL[] urls, Collection condencedPaths, boolean removeRedundantURLs) {
        SVNURL url;
        if (urls == null || urls.length == 0) {
            return null;
        }
        if (urls.length == 1) {
            return urls[0];
        }
        SVNURL rootURL = urls[0];
        int i = 0;
        while (i < urls.length) {
            rootURL = SVNURLUtil.getCommonURLAncestor(rootURL, urls[i]);
            ++i;
        }
        if (condencedPaths != null && removeRedundantURLs) {
            i = 0;
            while (i < urls.length) {
                SVNURL url1 = urls[i];
                if (url1 != null) {
                    int j = 0;
                    while (j < urls.length) {
                        SVNURL common;
                        SVNURL url2;
                        if (i != j && (url2 = urls[j]) != null && (common = SVNURLUtil.getCommonURLAncestor(url1, url2)) != null) {
                            if (common.equals(url1)) {
                                urls[j] = null;
                            } else if (common.equals(url2)) {
                                urls[i] = null;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            int j = 0;
            while (j < urls.length) {
                url = urls[j];
                if (url != null && url.equals(rootURL)) {
                    urls[j] = null;
                }
                ++j;
            }
        }
        if (condencedPaths != null) {
            i = 0;
            while (i < urls.length) {
                url = urls[i];
                if (url != null) {
                    String path = url.toString();
                    if (rootURL != null && (path = path.substring(rootURL.toString().length())).startsWith("/")) {
                        path = path.substring(1);
                    }
                    condencedPaths.add(path);
                }
                ++i;
            }
        }
        return rootURL;
    }
}

