/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNSkel {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final char TYPE_NOTHING = '\u0000';
    public static final char TYPE_SPACE = '\u0001';
    public static final char TYPE_DIGIT = '\u0002';
    public static final char TYPE_PAREN = '\u0003';
    public static final char TYPE_NAME = '\u0004';
    private static final char[] TYPES_TABLE;
    private final byte[] myRawData;
    private final List myList;

    static {
        char[] cArray = new char[256];
        cArray[9] = '\u0001';
        cArray[10] = '\u0001';
        cArray[12] = '\u0001';
        cArray[13] = '\u0001';
        cArray[32] = '\u0001';
        cArray[40] = 3;
        cArray[41] = 3;
        cArray[48] = 2;
        cArray[49] = 2;
        cArray[50] = 2;
        cArray[51] = 2;
        cArray[52] = 2;
        cArray[53] = 2;
        cArray[54] = 2;
        cArray[55] = 2;
        cArray[56] = 2;
        cArray[57] = 2;
        cArray[65] = 4;
        cArray[66] = 4;
        cArray[67] = 4;
        cArray[68] = 4;
        cArray[69] = 4;
        cArray[70] = 4;
        cArray[71] = 4;
        cArray[72] = 4;
        cArray[73] = 4;
        cArray[74] = 4;
        cArray[75] = 4;
        cArray[76] = 4;
        cArray[77] = 4;
        cArray[78] = 4;
        cArray[79] = 4;
        cArray[80] = 4;
        cArray[81] = 4;
        cArray[82] = 4;
        cArray[83] = 4;
        cArray[84] = 4;
        cArray[85] = 4;
        cArray[86] = 4;
        cArray[87] = 4;
        cArray[88] = 4;
        cArray[89] = 4;
        cArray[90] = 4;
        cArray[91] = 3;
        cArray[93] = 3;
        cArray[97] = 4;
        cArray[98] = 4;
        cArray[99] = 4;
        cArray[100] = 4;
        cArray[101] = 4;
        cArray[102] = 4;
        cArray[103] = 4;
        cArray[104] = 4;
        cArray[105] = 4;
        cArray[106] = 4;
        cArray[107] = 4;
        cArray[108] = 4;
        cArray[109] = 4;
        cArray[110] = 4;
        cArray[111] = 4;
        cArray[112] = 4;
        cArray[113] = 4;
        cArray[114] = 4;
        cArray[115] = 4;
        cArray[116] = 4;
        cArray[117] = 4;
        cArray[118] = 4;
        cArray[119] = 4;
        cArray[120] = 4;
        cArray[121] = 4;
        cArray[122] = 4;
        TYPES_TABLE = cArray;
    }

    public static char getType(byte b) {
        return TYPES_TABLE[b & 0xFF];
    }

    public static SVNSkel parse(byte[] data) throws SVNException {
        if (data == null) {
            return null;
        }
        return SVNSkel.parse(data, 0, data.length);
    }

    public static SVNSkel parse(byte[] data, int offset, int length) throws SVNException {
        if (data == null || length == 0 || offset + length > data.length) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(data, offset, length);
        return SVNSkel.parse(buffer);
    }

    public static SVNSkel parse(ByteBuffer buffer) throws SVNException {
        if (buffer == null || !buffer.hasRemaining()) {
            return null;
        }
        byte cur = buffer.get(buffer.position());
        if (cur == 40) {
            return SVNSkel.parseList(buffer);
        }
        if (SVNSkel.getType(cur) == '\u0004') {
            return SVNSkel.parseImplicitAtom(buffer);
        }
        return SVNSkel.parseExplicitAtom(buffer);
    }

    public static SVNSkel parseList(ByteBuffer buffer) throws SVNException {
        if (buffer == null || !buffer.hasRemaining()) {
            return null;
        }
        if (buffer.get() != 40) {
            return null;
        }
        if (!buffer.hasRemaining()) {
            return null;
        }
        SVNSkel list = SVNSkel.createEmptyList();
        while (true) {
            byte cur = 0;
            while (buffer.hasRemaining()) {
                cur = buffer.get();
                if (SVNSkel.getType(cur) != '\u0001') break;
            }
            if (cur == 41) break;
            SVNSkel element = SVNSkel.parse(buffer = SVNSkel.unread(buffer, 1));
            if (element == null) {
                return null;
            }
            list.appendChild(element);
        }
        return list;
    }

    public static SVNSkel parseImplicitAtom(ByteBuffer buffer) {
        if (buffer == null || !buffer.hasRemaining()) {
            return null;
        }
        if (SVNSkel.getType(buffer.get(buffer.position())) != '\u0004') {
            return null;
        }
        int start = buffer.position();
        while (buffer.hasRemaining()) {
            byte cur = buffer.get();
            if (SVNSkel.getType(cur) != '\u0001' && SVNSkel.getType(cur) != '\u0003') continue;
            buffer = SVNSkel.unread(buffer, 1);
            break;
        }
        return SVNSkel.createAtom(buffer.array(), buffer.arrayOffset() + start, buffer.position() - start);
    }

    public static SVNSkel parseExplicitAtom(ByteBuffer buffer) {
        if (buffer == null || !buffer.hasRemaining()) {
            return null;
        }
        int size = SVNSkel.parseSize(buffer, buffer.remaining());
        if (size < 0) {
            return null;
        }
        if (!buffer.hasRemaining() || SVNSkel.getType(buffer.get()) != '\u0001') {
            return null;
        }
        int start = buffer.arrayOffset() + buffer.position();
        buffer.position(buffer.position() + size);
        return SVNSkel.createAtom(buffer.array(), start, size);
    }

    public static SVNSkel createAtom(String str) {
        byte[] data;
        if (str == null) {
            return null;
        }
        try {
            data = str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            data = str.getBytes();
        }
        return new SVNSkel(data);
    }

    public static SVNSkel createAtom(byte[] data) {
        if (data == null) {
            return null;
        }
        return SVNSkel.createAtom(data);
    }

    public static SVNSkel createAtom(byte[] data, int offset, int length) {
        if (data == null) {
            return null;
        }
        byte[] raw = new byte[length];
        System.arraycopy(data, offset, raw, 0, length);
        return new SVNSkel(raw);
    }

    public static SVNSkel createEmptyList() {
        return new SVNSkel();
    }

    public static SVNSkel createPropList(Map props) throws SVNException {
        SVNSkel list = SVNSkel.createEmptyList();
        if (props == null) {
            return list;
        }
        for (Map.Entry entry : props.entrySet()) {
            SVNSkel name = SVNSkel.createAtom((String)entry.getKey());
            SVNSkel value = SVNSkel.createAtom((String)entry.getValue());
            list.addChild(value);
            list.addChild(name);
        }
        if (!list.isValidPropList()) {
            SVNSkel.error("proplist");
        }
        return list;
    }

    protected SVNSkel(byte[] data) {
        this.myRawData = data;
        this.myList = null;
    }

    protected SVNSkel() {
        this.myRawData = null;
        this.myList = new ArrayList();
    }

    public boolean isAtom() {
        return this.myList == null;
    }

    public byte[] getData() {
        return this.myRawData;
    }

    public List getList() {
        return Collections.unmodifiableList(this.myList);
    }

    public SVNSkel getChild(int i) throws SVNException {
        if (this.isAtom()) {
            SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.FS_MALFORMED_SKEL, "Unable to get a child from atom");
            SVNErrorManager.error(error, SVNLogType.DEFAULT);
        }
        return (SVNSkel)this.myList.get(i);
    }

    private void appendChild(SVNSkel child) throws SVNException {
        if (this.isAtom()) {
            SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.FS_MALFORMED_SKEL, "Unable to add a child to atom");
            SVNErrorManager.error(error, SVNLogType.DEFAULT);
        }
        this.myList.add(child);
    }

    public void addChild(SVNSkel child) throws SVNException {
        if (this.isAtom()) {
            SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.FS_MALFORMED_SKEL, "Unable to add a child to atom");
            SVNErrorManager.error(error, SVNLogType.DEFAULT);
        }
        this.myList.add(0, child);
    }

    public int getListSize() {
        if (this.isAtom()) {
            return -1;
        }
        return this.myList.size();
    }

    public String getValue() {
        if (this.isAtom()) {
            String str;
            try {
                str = new String(this.getData(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                str = new String(this.getData());
            }
            return str;
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.isAtom()) {
            buffer.append("[");
            buffer.append(this.getValue());
            buffer.append("]");
        } else {
            buffer.append("(");
            for (SVNSkel element : this.myList) {
                buffer.append(element.toString());
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    public boolean contentEquals(String str) {
        if (!this.isAtom()) {
            return false;
        }
        String value = this.getValue();
        return value.equals(str);
    }

    public boolean containsAtomsOnly() {
        if (this.isAtom()) {
            return false;
        }
        for (SVNSkel element : this.myList) {
            if (element.isAtom()) continue;
            return false;
        }
        return true;
    }

    public boolean isValidPropList() {
        int length = this.getListSize();
        if (length >= 0 && (length & 1) == 0) {
            return this.containsAtomsOnly();
        }
        return false;
    }

    public Map parsePropList() throws SVNException {
        if (!this.isValidPropList()) {
            SVNSkel.error("proplist");
        }
        SVNHashMap props = new SVNHashMap();
        Iterator iterator = this.myList.iterator();
        while (iterator.hasNext()) {
            SVNSkel nameElement = (SVNSkel)iterator.next();
            SVNSkel valueElement = (SVNSkel)iterator.next();
            String name = nameElement.getValue();
            String value = valueElement.getValue();
            props.put(name, value);
        }
        return props;
    }

    public byte[] unparse() throws SVNException {
        int approxSize = this.estimateUnparsedSize();
        ByteBuffer buffer = ByteBuffer.allocate(approxSize);
        buffer = this.writeTo(buffer);
        buffer.flip();
        byte[] raw = new byte[buffer.limit() - buffer.arrayOffset()];
        System.arraycopy(buffer.array(), buffer.arrayOffset(), raw, 0, buffer.limit());
        return raw;
    }

    public ByteBuffer writeTo(ByteBuffer buffer) throws SVNException {
        if (this.isAtom()) {
            byte[] data = this.getData();
            if (this.useImplicit()) {
                buffer = SVNSkel.allocate(buffer, data.length);
                buffer = buffer.put(data);
            } else {
                byte[] sizeBytes = SVNSkel.getSizeBytes(data.length);
                if (sizeBytes == null) {
                    SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.FS_MALFORMED_SKEL, "Unable to write size bytes to buffer");
                    SVNErrorManager.error(error, SVNLogType.DEFAULT);
                }
                buffer = SVNSkel.allocate(buffer, sizeBytes.length + 1 + data.length);
                buffer.put(sizeBytes);
                try {
                    buffer.put(" ".getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    buffer.put(" ".getBytes());
                }
                buffer.put(data);
            }
        } else {
            buffer = SVNSkel.allocate(buffer, 1);
            try {
                buffer.put("(".getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                buffer.put("(".getBytes());
            }
            Iterator iterator = this.myList.iterator();
            while (iterator.hasNext()) {
                SVNSkel element = (SVNSkel)iterator.next();
                buffer = element.writeTo(buffer);
                if (!iterator.hasNext()) continue;
                buffer = SVNSkel.allocate(buffer, 1);
                try {
                    buffer.put(" ".getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    buffer.put(" ".getBytes());
                }
            }
            buffer = SVNSkel.allocate(buffer, 1);
            try {
                buffer.put(")".getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                buffer.put(")".getBytes());
            }
        }
        return buffer;
    }

    private int estimateUnparsedSize() {
        if (this.isAtom()) {
            byte[] data = this.getData();
            if (data.length < 100) {
                return data.length + 3;
            }
            return data.length + 30;
        }
        int total = 2;
        for (SVNSkel element : this.myList) {
            total += element.estimateUnparsedSize();
            ++total;
        }
        return total;
    }

    private boolean useImplicit() {
        byte[] data = this.getData();
        if (data.length == 0 || data.length >= 100) {
            return false;
        }
        if (SVNSkel.getType(data[0]) != '\u0004') {
            return false;
        }
        int i = 0;
        while (i < data.length) {
            byte cur = data[i];
            if (SVNSkel.getType(cur) == '\u0001' || SVNSkel.getType(cur) == '\u0003') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static ByteBuffer allocate(ByteBuffer buffer, int capacity) {
        if (buffer == null) {
            capacity = Math.max(capacity * 3 / 2, 1024);
            return ByteBuffer.allocate(capacity);
        }
        if (capacity > buffer.remaining()) {
            ByteBuffer expandedBuffer = ByteBuffer.allocate((buffer.position() + capacity) * 3 / 2);
            buffer.flip();
            expandedBuffer.put(buffer);
            return expandedBuffer;
        }
        return buffer;
    }

    private static ByteBuffer unread(ByteBuffer buffer, int length) {
        buffer.position(buffer.position() - length);
        return buffer;
    }

    private static int parseSize(ByteBuffer buffer, int limit) {
        limit = limit < 0 ? Integer.MAX_VALUE : limit;
        int maxPrefix = limit / 10;
        int maxDigit = limit % 10;
        int value = 0;
        int start = buffer.position();
        while (buffer.hasRemaining()) {
            byte cur = buffer.get();
            if (48 <= cur && cur <= 57) {
                int digit = cur - 48;
                if (value > maxPrefix || value == maxPrefix && digit > maxDigit) {
                    return -1;
                }
                value = value * 10 + digit;
                continue;
            }
            buffer = SVNSkel.unread(buffer, 1);
            break;
        }
        if (start == buffer.position()) {
            return -1;
        }
        return value;
    }

    private static int writeSizeBytes(int value, byte[] data) {
        int i = 0;
        do {
            if (i >= data.length) {
                return -1;
            }
            data[i] = (byte)(value % 10 + 48);
            ++i;
        } while ((value /= 10) > 0);
        int left = 0;
        int right = i - 1;
        while (left < right) {
            byte tmp = data[left];
            data[left] = data[right];
            data[right] = tmp;
            ++left;
            --right;
        }
        return i;
    }

    private static byte[] getSizeBytes(int value) {
        int tmp = value;
        int length = 0;
        do {
            ++length;
        } while ((tmp /= 10) > 0);
        byte[] data = new byte[length];
        int count = SVNSkel.writeSizeBytes(value, data);
        if (count < 0) {
            return null;
        }
        if (count < data.length) {
            byte[] result = new byte[count];
            System.arraycopy(data, 0, result, 0, count);
            return result;
        }
        return data;
    }

    private static void error(String type) throws SVNException {
        SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.FS_MALFORMED_SKEL, "Malformed{0}{1} skeleton", new Object[]{type == null ? "" : " ", type == null ? "" : type});
        SVNErrorManager.error(error, SVNLogType.DEFAULT);
    }
}

