/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class FSWriteLock {
    private static final Map ourThreadDBLocksCache = new SVNHashMap();
    private static final Map ourThreadRepositoryLocksCache = new SVNHashMap();
    private static final Map ourThreadLogLocksCache = new SVNHashMap();
    private static final int DB_LOCK = 1;
    private static final int LOGS_LOCK = 2;
    private static final int REPOS_LOCK = 3;
    private File myLockFile;
    private RandomAccessFile myLockRAFile;
    private FileLock myLock;
    private String myToken;
    private int myLockType;
    private boolean myIsShared;
    private int myReferencesCount = 0;

    private FSWriteLock(String token, File lockFile, int lockType, boolean shared) {
        this.myToken = token;
        this.myLockFile = lockFile;
        this.myLockType = lockType;
        this.myIsShared = shared;
    }

    public static synchronized FSWriteLock getWriteLockForDB(FSFS owner) throws SVNException {
        String uuid = owner.getUUID();
        FSWriteLock lock = (FSWriteLock)ourThreadDBLocksCache.get(uuid);
        if (lock == null) {
            lock = new FSWriteLock(uuid, owner.getWriteLockFile(), 1, false);
            ourThreadDBLocksCache.put(uuid, lock);
        }
        ++lock.myReferencesCount;
        return lock;
    }

    public static synchronized FSWriteLock getWriteLockForCurrentTxn(String token, FSFS owner) throws SVNException {
        String uuid;
        FSWriteLock lock;
        if (token == null || token.length() == 0) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.FS_NO_LOCK_TOKEN, "Incorrect lock token for current transaction"), SVNLogType.FSFS);
        }
        if ((lock = (FSWriteLock)ourThreadDBLocksCache.get(uuid = String.valueOf(owner.getUUID()) + token)) == null) {
            lock = new FSWriteLock(uuid, owner.getTransactionCurrentLockFile(), 1, false);
            ourThreadDBLocksCache.put(uuid, lock);
        }
        ++lock.myReferencesCount;
        return lock;
    }

    public static synchronized FSWriteLock getWriteLockForTxn(String txnID, FSFS owner) throws SVNException {
        String uuid;
        FSWriteLock lock;
        if (txnID == null || txnID.length() == 0) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.FS_NO_LOCK_TOKEN, "Incorrect txn id while locking"), SVNLogType.FSFS);
        }
        if ((lock = (FSWriteLock)ourThreadDBLocksCache.get(uuid = String.valueOf(owner.getUUID()) + txnID)) == null) {
            lock = new FSWriteLock(uuid, owner.getTransactionProtoRevLockFile(txnID), 1, false);
            ourThreadDBLocksCache.put(uuid, lock);
        }
        ++lock.myReferencesCount;
        return lock;
    }

    public static synchronized FSWriteLock getDBLogsLock(FSFS owner, boolean exclusive) throws SVNException {
        String uuid = owner.getUUID();
        FSWriteLock lock = (FSWriteLock)ourThreadLogLocksCache.get(uuid);
        if (lock == null) {
            lock = new FSWriteLock(uuid, owner.getDBLogsLockFile(), 2, !exclusive);
            ourThreadLogLocksCache.put(uuid, lock);
        }
        ++lock.myReferencesCount;
        return lock;
    }

    public synchronized void lock() throws SVNException {
        boolean errorOccured = false;
        IOException childError = null;
        if (this.myLock != null) {
            errorOccured = true;
        }
        try {
            SVNFileType type = SVNFileType.getType(this.myLockFile);
            if (type == SVNFileType.UNKNOWN || type == SVNFileType.NONE) {
                SVNFileUtil.createEmptyFile(this.myLockFile);
            }
            this.myLockRAFile = new RandomAccessFile(this.myLockFile, "rw");
            this.myLock = this.myLockRAFile.getChannel().lock(0L, Long.MAX_VALUE, this.myIsShared);
        }
        catch (IOException ioe) {
            this.unlock();
            errorOccured = true;
            childError = ioe;
        }
        if (errorOccured) {
            String msg = childError == null ? "file already locked" : childError.getMessage();
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can''t get exclusive lock on file ''{0}'': {1}", new Object[]{this.myLockFile, msg});
            SVNErrorManager.error(err, childError, SVNLogType.FSFS);
        }
    }

    public static synchronized void release(FSWriteLock lock) {
        if (lock == null) {
            return;
        }
        if (--lock.myReferencesCount == 0) {
            if (lock.myLockType == 1) {
                ourThreadDBLocksCache.remove(lock.myToken);
            } else if (lock.myLockType == 3) {
                ourThreadRepositoryLocksCache.remove(lock.myToken);
            } else if (lock.myLockType == 2) {
                ourThreadLogLocksCache.remove(lock.myToken);
            }
        }
    }

    public synchronized void unlock() throws SVNException {
        if (this.myLock != null) {
            try {
                this.myLock.release();
            }
            catch (IOException ioex) {
                SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Unexpected error while releasing file lock on ''{0}''", this.myLockFile);
                SVNErrorManager.error(error, ioex, SVNLogType.FSFS);
            }
            this.myLock = null;
        }
        SVNFileUtil.closeFile(this.myLockRAFile);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{[");
        buffer.append("File:");
        buffer.append(this.myLockFile);
        buffer.append("][");
        buffer.append("RefCount:");
        buffer.append(this.myReferencesCount);
        buffer.append("][");
        buffer.append("Token:");
        buffer.append(this.myToken);
        buffer.append("]}");
        return buffer.toString();
    }
}

