/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.IFSRepresentationCacheManager;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class FSRepresentationCacheUtil {
    private static volatile boolean ourIsAvailable;
    private static final String SQLJET_DB_CLASS_NAME = "org.tmatesoft.sqljet.core.table.SqlJetDb";
    private static final String ANTLR_CLASS_NAME = "org.antlr.runtime.Token";
    private static final String REPCACHE_MANAGER_CLASS_NAME = "org.tmatesoft.svn.core.internal.io.fs.repcache.FSRepresentationCacheManager";
    private static Method ourOpenMethod;
    private static Method ourCreateMethod;

    static {
        ourOpenMethod = null;
        ourCreateMethod = null;
        Boolean option = Boolean.valueOf(System.getProperty("svnkit.fsfs.repcache", "true"));
        if (option.booleanValue()) {
            try {
                Class<?> antlrClazz = FSRepresentationCacheUtil.class.getClassLoader().loadClass(ANTLR_CLASS_NAME);
                if (antlrClazz == null) {
                    ourIsAvailable = false;
                } else {
                    Class<?> clazz = FSRepresentationCacheUtil.class.getClassLoader().loadClass(SQLJET_DB_CLASS_NAME);
                    ourIsAvailable = clazz != null;
                    clazz = FSRepresentationCacheUtil.class.getClassLoader().loadClass(REPCACHE_MANAGER_CLASS_NAME);
                    if (clazz != null) {
                        ourOpenMethod = clazz.getMethod("openRepresentationCache", FSFS.class);
                        ourCreateMethod = clazz.getMethod("createRepresentationCache", File.class);
                    }
                }
            }
            catch (Throwable e) {
                ourIsAvailable = false;
            }
        } else {
            ourIsAvailable = false;
        }
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.FSFS, "SQLJET enabled: " + ourIsAvailable);
    }

    public static IFSRepresentationCacheManager open(FSFS fsfs) throws SVNException {
        if (!FSRepresentationCacheUtil.isAvailable()) {
            return null;
        }
        if (ourOpenMethod != null) {
            try {
                Object result = ourOpenMethod.invoke(null, fsfs);
                if (result instanceof IFSRepresentationCacheManager) {
                    return (IFSRepresentationCacheManager)result;
                }
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof SVNException) {
                    throw (SVNException)e.getCause();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static void create(File path) throws SVNException {
        if (!FSRepresentationCacheUtil.isAvailable()) {
            return;
        }
        if (ourCreateMethod != null) {
            try {
                ourCreateMethod.invoke(null, path);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof SVNException) {
                    throw (SVNException)e.getCause();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static boolean isAvailable() {
        return ourIsAvailable;
    }
}

