/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSWriteLock;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;
import org.tmatesoft.svn.util.SVNLogType;

public class FSPacker {
    private ISVNCanceller myCanceller;
    private ISVNAdminEventHandler myNotifyHandler;

    public FSPacker(ISVNAdminEventHandler notifyHandler) {
        this.myCanceller = notifyHandler == null ? ISVNCanceller.NULL : notifyHandler;
        this.myNotifyHandler = notifyHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pack(FSFS fsfs) throws SVNException {
        FSWriteLock writeLock;
        FSWriteLock fSWriteLock = writeLock = FSWriteLock.getWriteLockForDB(fsfs);
        synchronized (fSWriteLock) {
            try {
                writeLock.lock();
                this.packImpl(fsfs);
            }
            finally {
                writeLock.unlock();
                FSWriteLock.release(writeLock);
            }
        }
    }

    private void packImpl(FSFS fsfs) throws SVNException {
        long youngestRev;
        long completedShards;
        long maxFilesPerDirectory;
        int format = fsfs.getDBFormat();
        if (format < 4) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_UNSUPPORTED_FORMAT, "FS format too old to pack, please upgrade.");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if ((maxFilesPerDirectory = fsfs.getMaxFilesPerDirectory()) <= 0L) {
            return;
        }
        long minUnpackedRev = fsfs.getMinUnpackedRev();
        if (minUnpackedRev == (completedShards = ((youngestRev = fsfs.getYoungestRevision()) + 1L) / maxFilesPerDirectory) * maxFilesPerDirectory) {
            return;
        }
        long i = minUnpackedRev / maxFilesPerDirectory;
        while (i < completedShards) {
            this.myCanceller.checkCancelled();
            this.packShard(fsfs, i);
            ++i;
        }
    }

    private void packShard(FSFS fsfs, long shard) throws SVNException {
        File shardPath;
        block10: {
            File packDir = fsfs.getPackDir(shard);
            File packFile = fsfs.getPackFile(shard);
            File manifestFile = fsfs.getManifestFile(shard);
            shardPath = new File(fsfs.getDBRevsDir(), String.valueOf(shard));
            this.firePackEvent(shard, true);
            SVNFileUtil.deleteAll(packDir, false, this.myCanceller);
            long startRev = shard * fsfs.getMaxFilesPerDirectory();
            long endRev = (shard + 1L) * fsfs.getMaxFilesPerDirectory() - 1L;
            long nextOffset = 0L;
            OutputStream packFileOS = null;
            OutputStream manifestFileOS = null;
            try {
                try {
                    packFileOS = SVNFileUtil.openFileForWriting(packFile);
                    manifestFileOS = SVNFileUtil.openFileForWriting(manifestFile);
                    long rev = startRev;
                    while (rev <= endRev) {
                        File path = new File(shardPath, String.valueOf(rev));
                        String line = String.valueOf(String.valueOf(nextOffset)) + '\n';
                        manifestFileOS.write(line.getBytes("UTF-8"));
                        nextOffset += path.length();
                        InputStream revIS = null;
                        try {
                            revIS = SVNFileUtil.openFileForReading(path);
                            FSRepositoryUtil.copy(revIS, packFileOS, this.myCanceller);
                        }
                        finally {
                            SVNFileUtil.closeFile(revIS);
                        }
                        ++rev;
                    }
                }
                catch (IOException ioe) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getMessage());
                    SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
                    SVNFileUtil.closeFile(packFileOS);
                    SVNFileUtil.closeFile(manifestFileOS);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(packFileOS);
                SVNFileUtil.closeFile(manifestFileOS);
                throw throwable;
            }
            SVNFileUtil.closeFile(packFileOS);
            SVNFileUtil.closeFile(manifestFileOS);
        }
        File finalPath = fsfs.getMinUnpackedRevFile();
        File tmpFile = SVNFileUtil.createUniqueFile(fsfs.getDBRoot(), "tempfile", ".tmp", false);
        String line = String.valueOf(String.valueOf((shard + 1L) * fsfs.getMaxFilesPerDirectory())) + '\n';
        SVNFileUtil.writeToFile(tmpFile, line, "UTF-8");
        SVNFileUtil.rename(tmpFile, finalPath);
        SVNFileUtil.deleteAll(shardPath, true, this.myCanceller);
        this.firePackEvent(shard, false);
    }

    private void firePackEvent(long shard, boolean start) throws SVNException {
        if (this.myNotifyHandler != null) {
            SVNAdminEvent event = new SVNAdminEvent(start ? SVNAdminEventAction.PACK_START : SVNAdminEventAction.PACK_END, shard);
            this.myNotifyHandler.handleAdminEvent(event, -1.0);
        }
    }
}

