/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class HTTPBodyInputStream
extends InputStream {
    private File myFile;
    private InputStream myDelegate;

    public HTTPBodyInputStream(File file) {
        this.myFile = file;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.getDelegate().read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.getDelegate().read(b);
    }

    public int read() throws IOException {
        return this.getDelegate().read();
    }

    public void close() throws IOException {
        if (this.myDelegate != null) {
            try {
                this.getDelegate().close();
            }
            finally {
                this.myDelegate = null;
            }
        }
    }

    public synchronized void reset() throws IOException {
        this.close();
    }

    private InputStream getDelegate() throws IOException {
        if (this.myDelegate == null) {
            try {
                this.myDelegate = SVNFileUtil.openFileForReading(this.myFile, SVNLogType.NETWORK);
            }
            catch (SVNException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e.getMessage());
            }
        }
        return this.myDelegate;
    }
}

