/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.client;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.ISVNProxyManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNProxyAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;

public class SVNClientAuthenticationManager
extends DefaultSVNAuthenticationManager {
    private DefaultSVNAuthenticationManager.SimpleProxyManager myDefaultProxyManager;
    private SVNSSHAuthentication myDefaultSSHCredentials;
    private SVNSSLAuthentication myDefaultSSLCredentials;
    private SVNSSHAuthentication myDefaultSSHCredentials2;
    private SVNProxyAuthentication myDefaultProxyCredentials;
    private boolean storeAuth;

    public SVNClientAuthenticationManager(File configDirectory, boolean storeAuth, boolean storeSSLAuth, String userName, String password) {
        super(configDirectory, storeAuth, storeSSLAuth, userName, password);
        this.storeAuth = storeAuth;
    }

    public void setClientSSLCertificate(String certPath, String passphrase) {
        this.myDefaultSSLCredentials = certPath != null ? new SVNSSLAuthentication(new File(certPath), passphrase, this.storeAuth) : null;
    }

    public void setSSHCredentials(String userName, String privateKeyPath, String passphrase, int portNumber) {
        this.myDefaultSSHCredentials = userName != null && privateKeyPath != null ? new SVNSSHAuthentication(userName, new File(privateKeyPath), passphrase, portNumber, this.storeAuth) : null;
    }

    public void setSSHCredentials(String userName, String password, int portNumber) {
        this.myDefaultSSHCredentials2 = userName != null ? new SVNSSHAuthentication(userName, password, portNumber, this.storeAuth) : null;
    }

    public boolean hasProxy() {
        return this.myDefaultProxyCredentials != null;
    }

    public void setProxy(String host, int port, String userName, String password) {
        if (host != null) {
            this.myDefaultProxyManager = new DefaultSVNAuthenticationManager.SimpleProxyManager(host, port < 0 ? null : Integer.toString(port), userName, password);
            this.myDefaultProxyCredentials = new SVNProxyAuthentication(userName, password, host, port, this.storeAuth);
        } else {
            this.myDefaultProxyManager = null;
            this.myDefaultProxyCredentials = null;
        }
    }

    public ISVNProxyManager getProxyManager(SVNURL url) throws SVNException {
        if (this.myDefaultProxyManager != null) {
            return this.myDefaultProxyManager;
        }
        return super.getProxyManager(url);
    }

    protected ISVNAuthenticationProvider createDefaultAuthenticationProvider(String userName, String password, File privateKey, String passphrase, boolean allowSave) {
        return new DefaultProvider(userName, password, privateKey, passphrase, allowSave);
    }

    protected class DefaultProvider
    extends DefaultSVNAuthenticationManager.DumbAuthenticationProvider {
        public DefaultProvider(String userName, String password, File privateKey, String passphrase, boolean store) {
            super(SVNClientAuthenticationManager.this, userName, password, privateKey, passphrase, store);
        }

        public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
            if (previousAuth == null) {
                if ("svn.ssh".equals(kind) && (SVNClientAuthenticationManager.this.myDefaultSSHCredentials != null || SVNClientAuthenticationManager.this.myDefaultSSHCredentials2 != null)) {
                    return SVNClientAuthenticationManager.this.myDefaultSSHCredentials != null ? SVNClientAuthenticationManager.this.myDefaultSSHCredentials : SVNClientAuthenticationManager.this.myDefaultSSHCredentials2;
                }
                if ("svn.ssl.client-passphrase".equals(kind) && SVNClientAuthenticationManager.this.myDefaultSSLCredentials != null) {
                    return SVNClientAuthenticationManager.this.myDefaultSSLCredentials;
                }
                if ("svn.proxy".equals(kind) && SVNClientAuthenticationManager.this.myDefaultProxyCredentials != null) {
                    return SVNClientAuthenticationManager.this.myDefaultProxyCredentials;
                }
            }
            if ("svn.proxy".equals(kind) && !SVNClientAuthenticationManager.this.hasProxy()) {
                return null;
            }
            return super.requestClientAuthentication(kind, url, realm, errorMessage, previousAuth, authMayBeStored);
        }
    }
}

