/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.line;

import de.regnis.q.sequence.line.QSequenceLine;
import de.regnis.q.sequence.line.QSequenceLineCache;
import de.regnis.q.sequence.line.simplifier.QSequenceLineSimplifier;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

final class QSequenceLineReader {
    private byte[] buffer;

    public QSequenceLineReader() {
        this(8192);
    }

    public QSequenceLineReader(int initialBufferSize) {
        this.buffer = new byte[initialBufferSize];
    }

    public void read(InputStream rawStream, QSequenceLineCache cache, QSequenceLineSimplifier simplifier) throws IOException {
        BufferedInputStream stream = new BufferedInputStream(rawStream);
        try {
            int ch;
            int pushBack = -1;
            int from = 0;
            int length = 0;
            do {
                if ((ch = pushBack) != -1) {
                    pushBack = -1;
                } else {
                    ch = stream.read();
                }
                if (ch != -1) {
                    this.append(length, (byte)(ch & 0xFF));
                    ++length;
                }
                switch (ch) {
                    case 13: {
                        pushBack = stream.read();
                        if (pushBack == 10) {
                            this.append(length, (byte)(pushBack & 0xFF));
                            ++length;
                            pushBack = -1;
                        }
                    }
                    case -1: 
                    case 10: {
                        if (length > 0) {
                            byte[] bytes = new byte[length];
                            System.arraycopy(this.buffer, 0, bytes, 0, length);
                            cache.addLine(new QSequenceLine(from, bytes, simplifier));
                        }
                        from += length;
                        length = 0;
                    }
                }
            } while (ch != -1);
        }
        finally {
            stream.close();
        }
    }

    private void append(int position, byte ch) {
        if (position >= this.buffer.length) {
            byte[] newArray = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newArray, 0, this.buffer.length);
            this.buffer = newArray;
        }
        this.buffer[position] = ch;
    }
}

