/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.squid.bridges;

import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.resources.Resource;
import org.sonar.java.api.JavaClass;
import org.sonar.java.api.JavaMethod;
import org.sonar.plugins.squid.bridges.Bridge;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceMethod;
import org.sonar.squid.measures.Metric;

public final class PublicUndocumentedApiBridge
extends Bridge {
    protected PublicUndocumentedApiBridge() {
        super(false);
    }

    public void onFile(SourceFile squidFile, Resource sonarFile) {
        this.copyValue((SourceCode)squidFile, sonarFile);
    }

    public void onClass(SourceClass squidClass, JavaClass sonarClass) {
        this.copyValue((SourceCode)squidClass, (Resource)sonarClass);
    }

    public void onMethod(SourceMethod squidMethod, JavaMethod sonarMethod) {
        this.copyValue((SourceCode)squidMethod, (Resource)sonarMethod);
    }

    private void copyValue(SourceCode squidResource, Resource sonarResource) {
        double undocumentedApi = squidResource.getDouble(Metric.PUBLIC_API) - (double)squidResource.getInt(Metric.PUBLIC_DOC_API);
        this.context.saveMeasure(sonarResource, CoreMetrics.PUBLIC_UNDOCUMENTED_API, Double.valueOf(undocumentedApi));
    }
}

