/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.squid.bridges;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.checks.CheckFactory;
import org.sonar.api.checks.NoSonarFilter;
import org.sonar.plugins.squid.bridges.Bridge;
import org.sonar.plugins.squid.bridges.ChecksBridge;
import org.sonar.plugins.squid.bridges.ChidamberKemererBridge;
import org.sonar.plugins.squid.bridges.CopyBasicMeasuresBridge;
import org.sonar.plugins.squid.bridges.DesignBridge;
import org.sonar.plugins.squid.bridges.Lcom4BlocksBridge;
import org.sonar.plugins.squid.bridges.NoSonarFilterLoader;
import org.sonar.plugins.squid.bridges.PackagesBridge;
import org.sonar.plugins.squid.bridges.PublicUndocumentedApiBridge;
import org.sonar.plugins.squid.bridges.ResourceIndex;
import org.sonar.plugins.squid.bridges.RobertCMartinBridge;
import org.sonar.squid.Squid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BridgeFactory {
    private BridgeFactory() {
    }

    private static List<Bridge> create(NoSonarFilter noSonarFilter) {
        return Arrays.asList(new CopyBasicMeasuresBridge(), new PackagesBridge(), new PublicUndocumentedApiBridge(), new NoSonarFilterLoader(noSonarFilter), new ChidamberKemererBridge(), new RobertCMartinBridge(), new DesignBridge(), new Lcom4BlocksBridge(), new ChecksBridge());
    }

    public static List<Bridge> create(boolean bytecodeScanned, SensorContext context, CheckFactory checkFactory, ResourceIndex resourceIndex, Squid squid, NoSonarFilter noSonarFilter) {
        ArrayList<Bridge> result = new ArrayList<Bridge>();
        for (Bridge bridge : BridgeFactory.create(noSonarFilter)) {
            bridge.setCheckFactory(checkFactory);
            if (bridge.needsBytecode() && !bytecodeScanned) continue;
            bridge.setContext(context);
            bridge.setSquid(squid);
            bridge.setResourceIndex(resourceIndex);
            result.add(bridge);
        }
        return result;
    }
}

