/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.squid.check;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.squid.check.SquidCheck;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.CodeCheck;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.measures.Metric;

@Rule(key="EmptyFile", name="Empty file", priority=Priority.MAJOR, description="Detect empty files, which do not have any lines of code. Example: <pre>\n//package org.foo;\n//\n//public class Bar {}\n</pre>")
public final class EmptyFileCheck
extends SquidCheck {
    public void visitFile(SourceFile file) {
        int loc = file.getInt(Metric.LINES_OF_CODE);
        if (loc == 0) {
            CheckMessage message = new CheckMessage((CodeCheck)this, "This Java file is empty", new Object[0]);
            file.log(message);
        }
    }
}

